<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<script src="/assets/jquery/jquery-3.1.1.min.js"></script>
<script src="/assets/layui-2.9.18/layui.js"></script>
<link rel="stylesheet" href="/assets/layui-2.9.18/css/layui.css">
<link rel="stylesheet" href="/assets/layui-2.9.18/css/admin.css">
<script src="/assets/september/common.js"></script>
<script src="/assets/september/htmlBuilder.js"></script>
<script src="/assets/september/search.js"></script>
<link rel="stylesheet" href="/assets/pages/list.css">
</head>
<body class="layui-layout-body">
	<div id="LAY_app">
		<div class="layui-layout layui-layout-admin">
			<!-- 主体内容 -->
				<div class="layui-fluid">
					<div class="layui-card">
						<div class="layui-form layui-card-header layuiadmin-card-header-auto">
							<div class="layui-form-item">
								<div class="layui-inline">
									<label class="layui-search-form-label">名称</label>
									<div class="layui-search-input-inline">
										<input type="text" name="name" autocomplete="off" class="layui-input">
									</div>
								</div>

								<div class="layui-inline">
									<button class="layui-btn layuiadmin-btn-list" lay-submit lay-filter="LAY-app-contlist-search" onclick="doSearch(1);">
										<i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
									</button>
									<button class="layui-btn layuiadmin-btn-list" onclick="openAddSystemRole();">添加</button>
								</div>
							</div>
						</div>

						<div class="layui-card-body">

							<div id="form" class="layui-table-box layui-form" lay-filter="SystemRoleList">
								<table id="LAY-app-content-list" lay-filter="LAY-app-content-list" class="layui-table">
									<thead>
										<tr>
											<td align="center"><span>名称</span></td>
											<td align="center"><span>描述</span></td>
											<th data-minwidth="150" class=" layui-table-col-special">
												<div class="layui-table-cell" align="center">
													<span>操作</span>
												</div>
											</th>
										</tr>
									</thead>
									<tbody class="layui-table-body layui-table-main">
										<tr class="data_row" style="display: none">
											<td align="center"><span>$[name]</span></td>
											<td align="center"><span>$[remark]</span></td>
											<td align="center" data-minwidth="150" class="layui-table-col-special">
												<div class="layui-table-cell">
													<a class="layui-btn layui-btn-normal layui-btn-xs" onclick="openEditSystemRole($[id])">编辑</a>
													<a class="layui-btn layui-btn-normal layui-btn-xs" onclick="openGrantPermission($[id])">权限</a>
													<a class="layui-btn layui-btn-normal layui-btn-xs" onclick="cloneSystemRole($[id])">克隆</a>
													<a class="layui-btn layui-btn-danger layui-btn-xs" onclick="deleteSystemRole($[id])">删除</a>
												</div>
											</td>
										</tr>
									</tbody>
								</table>
							</div>

							<div class="layui-card-body">
								<div id="page"></div>
							</div>
						</div>
					</div>
				</div>
			<!-- 主体内容结束-->
		</div>
	</div>

<script type="text/javascript">
	searchUrl = '/userPermission/systemRole/listSystemRoleData';
	layui.use(function(){
    	var layer = layui.layer;
    	doSearch(1);
  	});

	function openAddSystemRole() {
		layer.open({maxmin : true,
			type : 2,
			title : '添加角色',
			area : [ '50%', '300px' ],
			content : '/userPermission/systemRole/addSystemRole'
		});
	}

	function openEditSystemRole(id) {
		layer.open({maxmin : true,
			type : 2,
			title : '编辑角色',
			area : [ '50%', '300px' ],
			content : '/userPermission/systemRole/editSystemRole?id=' + id
		});
	}

	function openGrantPermission(id) {
		layer.open({maxmin : true,
			type : 2,
			title : '角色授权',
			area : [ '800px', '500px' ],
			content : '/userPermission/systemRole/grantPermission?roleId=' + id+'&readonly=true'
		});
	}

	function deleteSystemRole(id) {
		confirmDelete(function() {
			sajax({
				type : "POST",
				url : "/userPermission/systemRole/delete?id=" + id,
				success : function(data) {
					doPage(currentPage);
					layer.msg('删除成功');
				}
			});
		});
	}

	function cloneSystemRole(id) {
		layer.confirm('确定要克隆这个角色吗？', {
	        btn: ['是', '否']
	        //按钮
	    }, function () {
	        sajax({
				type : "POST",
				url : "/userPermission/systemRole/doClone?id=" + id,
				success : function(data) {
					doPage(currentPage);
					layer.msg('克隆成功');
				}
			});
	    });
	}
	
</script>


</body>
</html>
