/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.aop;

import com.alibaba.fastjson.JSON;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.september.pisces.user.permission.controller.DefaultLoginController;
import org.september.pisces.user.permission.entity.SystemUser;
import org.september.pisces.user.permission.service.PiscesPermissionService;
import org.september.pisces.user.permission.service.TokenSessionManager;
import org.september.pisces.user.permission.utils.UserSessionHelper;
import org.september.simpleweb.model.ResponseVo;
import org.september.simpleweb.utils.RequestUtil;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Component
public class MvInterceptor
implements HandlerInterceptor {
    private BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
    private TemplateHashModel staticModels = this.wrapper.getStaticModels();
    public static String plateName = "";
    public static String yezhuName = "";
    @Autowired
    private PiscesPermissionService permissionService;

    public MvInterceptor() {
        System.out.println();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        String reqUrl = request.getRequestURI();
        SmartDatasourceHolder.setDataSourceGroup(null);
        if ("/".equals(reqUrl)) {
            response.sendRedirect(DefaultLoginController.LoginPageUrl);
            return false;
        }
        if ("/login".equals(reqUrl)) {
            return true;
        }
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        String target = request.getParameter("menu");
        if (target != null) {
            reqUrl = target;
        }
        if (this.permissionService.isPublic(reqUrl = reqUrl.split("\\?")[0])) {
            return true;
        }
        SystemUser account = null;
        if (TokenSessionManager.isEnableToken()) {
            account = TokenSessionManager.getSessionUser();
            if (account == null) {
                ResponseVo data = ResponseVo.BUILDER().setData((Object)"403").setCode(Integer.valueOf(-1)).setDesc("\u8bf7\u5148\u767b\u5f55");
                response.setContentType("text/plain; charset=UTF-8");
                response.getWriter().write(JSON.toJSONString((Object)data));
                return false;
            }
        } else {
            account = UserSessionHelper.getLoginUser();
            if (account == null) {
                if (target != null) {
                    response.sendRedirect(DefaultLoginController.LoginPageUrl + "?returnUrl=" + request.getRequestURI() + "?" + request.getQueryString());
                } else {
                    response.sendRedirect(DefaultLoginController.LoginPageUrl);
                }
                return false;
            }
        }
        if ("superadmin".equals(account.getUsername())) {
            return true;
        }
        if (this.permissionService.isDefault(reqUrl)) {
            return true;
        }
        if (account.hasPermission(reqUrl)) {
            return true;
        }
        if (RequestUtil.checkIfAjax((HttpServletRequest)request)) {
            response.sendRedirect("/503");
            return false;
        }
        ResponseVo res = ResponseVo.BUILDER().setCode(Integer.valueOf(-1)).setDesc("\u6743\u9650\u4e0d\u8db3");
        response.setContentType("text/plain; charset=UTF-8");
        response.getOutputStream().write(JSON.toJSONString((Object)res).getBytes("utf8"));
        return false;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null) {
            return;
        }
        SystemUser account = UserSessionHelper.getLoginUser();
        if (account != null) {
            modelAndView.addObject("user", (Object)account);
        }
        modelAndView.addObject("yezhuName", (Object)yezhuName);
        modelAndView.addObject("plateName", (Object)plateName);
        HandlerMethod method = (HandlerMethod)o;
        TemplateHashModel optionValueTypeStatics = (TemplateHashModel)this.staticModels.get(method.getBeanType().getName());
        modelAndView.addObject(method.getBeanType().getSimpleName(), (Object)optionValueTypeStatics);
    }
}

