/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.controller;

import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import org.september.core.constant.enums.DeleteFlag;
import org.september.core.exception.BusinessException;
import org.september.pisces.user.permission.entity.SystemRole;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.pisces.user.permission.service.PiscesPermissionService;
import org.september.pisces.user.permission.service.SystemRoleService;
import org.september.pisces.user.permission.vo.PermissionTreeNode;
import org.september.pisces.user.permission.vo.TreeItem;
import org.september.simpleweb.controller.BaseController;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.CommonDao;
import org.september.smartdao.CommonValidator;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PiscesSystemRoleController
extends BaseController {
    private static final String Mapping_Prefix = "/userPermission/systemRole";
    public static final String List_Page = "/userPermission/systemRole/systemRoleList";
    public static final String List_Data = "/userPermission/systemRole/listSystemRoleData";
    public static final String Add_Page = "/userPermission/systemRole/addSystemRole";
    public static final String Add_Action = "/userPermission/systemRole/doAddSystemRole";
    public static final String Edit_Page = "/userPermission/systemRole/editSystemRole";
    public static final String Edit_Action = "/userPermission/systemRole/doUpdateSystemRole";
    public static final String Delete_Action = "/userPermission/systemRole/delete";
    public static final String Grant_Permission_Page = "/userPermission/systemRole/grantPermission";
    public static final String Grant_Permission_Action = "/userPermission/systemRole/doGrantPermission";
    public static final String Clone_Action = "/userPermission/systemRole/doClone";
    @Autowired
    private CommonDao commonDao;
    @Autowired
    private CommonValidator commonValidator;
    @Autowired
    private PiscesPermissionService permissionService;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private SystemRoleService systemRoleService;

    @RequestMapping(value={"/userPermission/systemRole/systemRoleList"})
    public ModelAndView systemRoleList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemRole/listSystemRoleData"})
    public ResponseVo<Page<SystemRole>> listSystemRoleData(Page<SystemRole> page, String name) throws Exception {
        ParamMap pm = new ParamMap();
        pm.put("name", (Object)name);
        page = this.commonDao.findPageByParams(SystemRole.class, page, "PiscesSystemRole.listSystemRole", pm);
        return ResponseVo.BUILDER().setData((Object)page).setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/userPermission/systemRole/addSystemRole"})
    public ModelAndView addSystemRole() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemRole/doAddSystemRole"})
    public ResponseVo<String> doAddSystemRole(@Valid SystemRole systemRole) throws Exception {
        boolean exist = this.commonValidator.exsits(SystemRole.class, new String[]{"name", "deleteFlag"}, new Object[]{systemRole.getName(), DeleteFlag.NotDelete.ordinal()});
        if (exist) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
        }
        this.commonDao.save((Object)systemRole);
        this.operationLogService.addLog("\u6dfb\u52a0\u4e86\u89d2\u8272\u3010" + systemRole.getName() + "\u3011");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/userPermission/systemRole/editSystemRole"})
    public ModelAndView editSystemRole(Long id) throws Exception {
        ModelAndView mv = new ModelAndView();
        SystemRole po = (SystemRole)this.commonDao.get(SystemRole.class, (Object)id);
        mv.addObject("systemRole", (Object)po);
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemRole/doUpdateSystemRole"})
    public ResponseVo<String> doUpdateSystemRole(@Valid SystemRole systemRole) throws Exception {
        boolean exist = this.commonValidator.exsitsNotMe(SystemRole.class, new String[]{"name", "deleteFlag"}, new Object[]{systemRole.getName(), DeleteFlag.NotDelete.ordinal()}, (Object)systemRole.getId());
        if (exist) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!");
        }
        this.commonDao.update((Object)systemRole);
        this.operationLogService.addLog("\u4fee\u6539\u89d2\u8272\u3010" + systemRole.getName() + "\u3011\u4fe1\u606f");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemRole/delete"})
    public ResponseVo<String> delete(Long id) throws Exception {
        SystemRole po = (SystemRole)this.commonDao.get(SystemRole.class, (Object)id);
        if (po == null) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        po.setDeleteFlag(1);
        this.commonDao.update((Object)po);
        this.operationLogService.addLog("\u5220\u9664\u4e86\u89d2\u8272\u3010" + po.getName() + "\u3011");
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemRole/doClone"})
    public ResponseVo<String> clone(Long id) throws Exception {
        SystemRole po = (SystemRole)this.commonDao.get(SystemRole.class, (Object)id);
        if (po == null) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        this.systemRoleService.cloneRole(po);
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/userPermission/systemRole/grantPermission"})
    public ModelAndView grantPermission(Long roleId, Boolean readonly) throws Exception {
        ModelAndView mv = new ModelAndView();
        Collection<PermissionTreeNode> pdList = this.permissionService.getAllPermissions();
        ArrayList<TreeItem> tiList = new ArrayList<TreeItem>();
        for (PermissionTreeNode pd : pdList) {
            for (TreeItem ti : this.permissionService.toTreeItem(pd)) {
                if (ti.getParentId() == null) {
                    ti.setParentId("-1");
                }
                if (tiList.contains(ti)) continue;
                tiList.add(ti);
            }
        }
        this.permissionService.selectTreeItem(tiList, roleId);
        mv.addObject("itemList", tiList);
        mv.addObject("roleId", (Object)roleId);
        mv.addObject("viewonly", (Object)(readonly == null ? false : readonly));
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/userPermission/systemRole/doGrantPermission"})
    public ResponseVo<String> doGrantPermission(Long roleId, String resources, String remark) throws Exception {
        SystemRole po = (SystemRole)this.commonDao.get(SystemRole.class, (Object)roleId);
        this.permissionService.doGrantPermission(roleId, resources);
        this.operationLogService.addLog("\u4fee\u6539\u4e86\u89d2\u8272\u3010" + po.getName() + "\u3011\u7684\u6743\u9650");
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }
}

