/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.service;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.september.pisces.user.permission.entity.SystemUser;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TokenSessionManager {
    private static final String tokenName = "user-token";
    private static Map<String, SystemUser> sessionUsers = new HashMap<String, SystemUser>();

    public static synchronized HttpServletRequest getRequest() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (sra != null);
        return sra.getRequest();
    }

    public static String getToken() {
        HttpServletRequest request = TokenSessionManager.getRequest();
        return request.getHeader(tokenName);
    }

    public static boolean isEnableToken() {
        HttpServletRequest request = TokenSessionManager.getRequest();
        return request.getHeader(tokenName) != null;
    }

    public static String addSessionUser(SystemUser su) {
        String token = UUID.randomUUID().toString();
        sessionUsers.put(token, su);
        return token;
    }

    public static void removeSessionUser() {
        sessionUsers.remove(TokenSessionManager.getToken());
    }

    public static SystemUser getSessionUser() {
        return sessionUsers.get(TokenSessionManager.getToken());
    }
}

