/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.core.exception.BusinessException;
import org.september.pisces.user.permission.entity.RolePermission;
import org.september.pisces.user.permission.service.SystemUserService;
import org.september.pisces.user.permission.vo.PermissionTreeNode;
import org.september.pisces.user.permission.vo.TreeItem;
import org.september.smartdao.CommonDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PiscesPermissionService {
    private List<String> publicUrls = new ArrayList<String>();
    private List<String> defaultUrls = new ArrayList<String>();
    private static Map<String, PermissionTreeNode> permissionDataMap = new HashMap<String, PermissionTreeNode>();
    @Autowired
    private CommonDao dao;
    @Autowired
    private SystemUserService systemUserService;

    public boolean isPublic(String url) {
        return this.publicUrls.contains(url);
    }

    public boolean isDefault(String url) {
        return this.defaultUrls.contains(url);
    }

    public void addPublicUrl(String url) {
        this.publicUrls.add(url);
    }

    public void addDefaultUrl(String url) {
        this.defaultUrls.add(url);
    }

    public void clonePermission(Long srcRoleId, Long newRoleId) {
        RolePermission rp = new RolePermission();
        rp.setRoleId(srcRoleId);
        List list = this.dao.listByExample((Object)rp);
        ArrayList<RolePermission> newList = new ArrayList<RolePermission>();
        for (RolePermission perm : list) {
            RolePermission newPerm = new RolePermission();
            newPerm.setRoleId(newRoleId);
            newPerm.setResource(perm.getResource());
            newList.add(newPerm);
        }
        this.dao.batchInsert(RolePermission.class, newList);
    }

    @Transactional
    public void doGrantPermission(Long roleId, String paths) {
        List<RolePermission> persistPerms = this.systemUserService.getPermissionOfRole(roleId);
        ArrayList<RolePermission> removeList = new ArrayList<RolePermission>();
        ArrayList<RolePermission> addList = new ArrayList<RolePermission>();
        ArrayList<String> peristResList = new ArrayList<String>();
        ArrayList<String> newList = new ArrayList<String>();
        for (String path : paths.split(";")) {
            newList.addAll(this.getResourceByPath(path));
        }
        for (RolePermission perm : persistPerms) {
            peristResList.add(perm.getResource());
        }
        for (RolePermission perm : persistPerms) {
            if (newList.contains(perm.getResource())) continue;
            removeList.add(perm);
        }
        for (String res : newList) {
            if (peristResList.contains(res)) continue;
            addList.add(new RolePermission(roleId, res));
        }
        if (addList.isEmpty() && removeList.isEmpty()) {
            throw new BusinessException("\u6ca1\u6709\u4fee\u6539\u4efb\u4f55\u6743\u9650\uff0c\u65e0\u9700\u5ba1\u6838\uff01");
        }
        for (RolePermission perm : removeList) {
            this.dao.delete((Object)perm);
        }
        for (RolePermission perm : addList) {
            this.dao.save((Object)perm);
        }
    }

    public Collection<PermissionTreeNode> getAllPermissions() {
        return permissionDataMap.values();
    }

    public List<String> getResourceByPath(String path) {
        PermissionTreeNode data = permissionDataMap.get(path);
        if (data != null) {
            return data.getResource();
        }
        return new ArrayList<String>();
    }

    public List<TreeItem> toTreeItem(PermissionTreeNode perm) {
        String[] arr = perm.getPath().split("-");
        Object path = "";
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        for (int i = 0; i < arr.length; ++i) {
            TreeItem ti = new TreeItem();
            if (i == 0) {
                ti.setText(arr[i]);
                path = arr[i];
                ti.setPath((String)path);
                ti.setId((String)path);
            } else {
                ti.setText(arr[i]);
                ti.setParentId((String)path);
                path = (String)path + "-" + arr[i];
                ti.setPath((String)path);
                ti.setId((String)path);
            }
            result.add(ti);
        }
        return result;
    }

    public void selectTreeItem(List<TreeItem> tiList, long roleId) {
        RolePermission vo = new RolePermission();
        vo.setRoleId(roleId);
        List list = this.dao.listByExample((Object)vo);
        for (RolePermission rp : list) {
            for (TreeItem ti : tiList) {
                this.selectTreeItem(ti, rp);
            }
        }
    }

    public void selectTreeItem(TreeItem ti, RolePermission perm) {
        List<String> resList = this.getResourceByPath(ti.getPath());
        if (resList != null && resList.contains(perm.getResource())) {
            ti.setCheckFlag(1);
        }
    }

    public static void addPermissionData(String path, String ... reses) {
        PermissionTreeNode pd = new PermissionTreeNode();
        pd.setPath(path);
        for (String res : reses) {
            pd.getResource().add(res);
        }
        permissionDataMap.put(path, pd);
    }
}

