/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.task.service;

import java.util.LinkedHashMap;
import java.util.Map;
import org.september.core.component.log.LogHelper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class DynamicScheduledTaskRegistrar
extends ScheduledTaskRegistrar {
    protected LogHelper log = LogHelper.getLogger(((Object)((Object)this)).getClass());
    final Map<String, ScheduledTask> scheduledTaskMap = new LinkedHashMap<String, ScheduledTask>(16);
    private ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();

    public DynamicScheduledTaskRegistrar(int pooSize) {
        this.taskScheduler.setPoolSize(pooSize);
        this.taskScheduler.setRemoveOnCancelPolicy(true);
        this.taskScheduler.setThreadNamePrefix("dynamic-scheduled-task-");
        this.taskScheduler.initialize();
        this.setScheduler(this.taskScheduler);
    }

    Boolean addCronTask(String taskName, String cron, Runnable runnable) {
        if (this.scheduledTaskMap.containsKey(taskName)) {
            this.log.getBuilder().error("\u5b9a\u65f6\u4efb\u52a1[" + taskName + "]\u5df2\u5b58\u5728\uff0c\u6dfb\u52a0\u5931\u8d25");
            return Boolean.FALSE;
        }
        CronTask cronTask = new CronTask(runnable, cron);
        ScheduledTask scheduledTask = this.scheduleCronTask(cronTask);
        this.scheduledTaskMap.put(taskName, scheduledTask);
        this.log.getBuilder().info("\u5b9a\u65f6\u4efb\u52a1[" + taskName + "]\u65b0\u589e\u6210\u529f");
        return Boolean.TRUE;
    }

    void cancelCronTask(String taskName) {
        ScheduledTask scheduledTask = this.scheduledTaskMap.get(taskName);
        if (null != scheduledTask) {
            scheduledTask.cancel();
            this.scheduledTaskMap.remove(taskName);
        }
        this.log.getBuilder().info("\u5b9a\u65f6\u4efb\u52a1[" + taskName + "]\u5220\u9664\u6210\u529f");
    }

    public void destroy() {
        super.destroy();
        this.scheduledTaskMap.values().forEach(ScheduledTask::cancel);
    }

    public void updateThreadPoolSize(int size) {
        this.taskScheduler.setPoolSize(size);
    }
}

