/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.operation.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.september.pisces.operation.enums.OperationSettingEnum;
import org.september.pisces.operation.util.DatasourceConfigUtil;
import org.september.pisces.settings.api.IPiscecSystemSettting;
import org.september.pisces.settings.entity.SystemSettings;
import org.september.pisces.settings.service.PiscesSettingService;
import org.september.smartdao.CommonDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DbBackupService {
    private static final Logger log = LoggerFactory.getLogger(DbBackupService.class);
    @Autowired
    PiscesSettingService settingService;
    @Autowired
    CommonDao commonDao;
    @Value(value="${spring.alliance.dao.dialect:mysql}")
    private String dialect;
    private static final long maxSize = 1048576000L;
    private static final Pattern mysql_url_pattern = Pattern.compile("jdbc:mysql://([^:/]+)(?::(\\d+))?/([^?]+).*");

    public void dbBackup() {
        Object backupDate = this.settingService.getValueOrDefault((IPiscecSystemSettting)OperationSettingEnum.\u6570\u636e\u5e93\u5907\u4efd\u5468\u671f);
        if (((String)backupDate).contains("|")) {
            String[] parts = ((String)backupDate).split("\\|");
            int intervalDays = Integer.parseInt(parts[0]);
            String lastBackupDate = parts[1];
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)DateUtil.parse((CharSequence)lastBackupDate, (String)"yyyy-MM-dd"));
            calendar.add(5, intervalDays);
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            if (!calendar.before(today)) {
                return;
            }
        }
        boolean result = true;
        Object saveFilePath = this.settingService.getValueOrDefault((IPiscecSystemSettting)OperationSettingEnum.\u6570\u636e\u5e93\u5907\u4efd\u8def\u5f84);
        saveFilePath = (String)saveFilePath + "//" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        List<DatasourceConfigUtil.DataSourceConfig> list = DatasourceConfigUtil.getDatasource();
        for (DatasourceConfigUtil.DataSourceConfig config : list) {
            if (!"mysql".equalsIgnoreCase(this.dialect)) {
                log.info("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u5907\u4efd\u7c7b\u578b\uff1a" + this.dialect);
                break;
            }
            Matcher matcher = mysql_url_pattern.matcher(config.getJdbcUrl());
            if (!matcher.matches()) {
                log.info("\u6570\u636e\u5e93jdbcUrl\u914d\u7f6e\u9519\u8bef\uff1a" + config.getJdbcUrl());
                continue;
            }
            String host = matcher.group(1);
            String port = matcher.group(2);
            String database = matcher.group(3);
            FileUtil.mkdir((String)saveFilePath);
            try {
                ProcessBuilder pb = new ProcessBuilder("mysqldump", "-u" + config.getUsername(), "-p" + config.getPassword(), "-h" + host, "-P" + port, "--databases", database);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                int fileIndex = 1;
                long currentSize = 0L;
                File outFile = new File((String)saveFilePath, String.format("db_%s_%d.sql", database, fileIndex));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8), 0x100000);
                try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8), 0x100000);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        byte[] data = (line + System.lineSeparator()).getBytes(StandardCharsets.UTF_8);
                        if (currentSize + (long)data.length > 1048576000L && line.trim().endsWith(";")) {
                            writer.close();
                            log.info("\u751f\u6210\u6570\u636e\u5e93\u5907\u4efd\u5206\u7247: " + outFile.getAbsolutePath());
                            outFile = new File((String)saveFilePath, String.format("db_%s_%d.sql", database, ++fileIndex));
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8), 0x100000);
                            currentSize = 0L;
                        }
                        writer.write(line);
                        writer.newLine();
                        currentSize += (long)data.length;
                    }
                }
                writer.close();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    log.info(database + " \u6570\u636e\u5e93\u5907\u4efd\u5b8c\u6210\uff0c\u5171\u751f\u6210 " + fileIndex + " \u4e2a\u6587\u4ef6\u3002");
                    continue;
                }
                log.error("mysqldump \u6267\u884c\u5931\u8d25\uff0cexitCode=" + exitCode);
                result = false;
                break;
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u5e93\u5907\u4efd\u5f02\u5e38\uff1a", (Throwable)e);
                result = false;
            }
        }
        if (result) {
            ZipUtil.zip((String)saveFilePath);
            FileUtil.del((String)saveFilePath);
            String date = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
            backupDate = ((String)backupDate).contains("|") ? ((String)backupDate).split("\\|")[0] : backupDate;
            backupDate = (String)backupDate + "|" + date;
            SystemSettings settings = new SystemSettings();
            settings.setCfgKey(OperationSettingEnum.\u6570\u636e\u5e93\u5907\u4efd\u5468\u671f.getKey());
            settings.setGroupName(OperationSettingEnum.\u6570\u636e\u5e93\u5907\u4efd\u5468\u671f.getGroup());
            settings = (SystemSettings)this.commonDao.getByExample((Object)settings);
            settings.setCfgVal((String)backupDate);
            this.commonDao.update((Object)settings);
        }
    }
}

