/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.menuframe.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.service.FileStoreManager;
import org.september.pisces.menuframe.MenuFrameModule;
import org.september.pisces.menuframe.service.FrameService;
import org.september.pisces.menuframe.vo.MenuTree;
import org.september.pisces.menuframe.vo.SimpleMenu;
import org.september.pisces.settings.service.PiscesSettingService;
import org.september.pisces.user.permission.entity.SystemUser;
import org.september.pisces.user.permission.utils.UserSessionHelper;
import org.september.simpleweb.auth.PublicMethod;
import org.september.simpleweb.model.ResponseVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@PublicMethod
@Controller
@RequestMapping(value={"/frame"})
public class FrameController {
    @Autowired
    private FileStoreManager fileStoreManager;
    @Autowired
    private PiscesSettingService settingService;
    @Autowired
    private FrameService frameService;

    @RequestMapping(value={"/index"})
    public ModelAndView index(String menu) throws Exception {
        ModelAndView mv = new ModelAndView();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map pMap = request.getParameterMap();
        for (String pname : pMap.keySet()) {
            if ("menu".equals(pname)) continue;
            menu = (String)menu + "&" + pname + "=" + request.getParameter(pname);
        }
        mv.addObject("menu", menu);
        mv.addObject("realName", (Object)UserSessionHelper.getLoginUser().getRealname());
        if (UserSessionHelper.getMenuTree() == null) {
            MenuTree mt = this.buildUserMenu(UserSessionHelper.getLoginUser());
            UserSessionHelper.setMenuTree((Object)mt);
        }
        mv.addObject("menuTree", UserSessionHelper.getMenuTree());
        mv.addObject("commonIncludeFtls", MenuFrameModule.commonIncludeFtls);
        mv.addObject("logoUrl", (Object)this.frameService.getLogoUrl());
        return mv;
    }

    @RequestMapping(value={"/uploadLogo"})
    @ResponseBody
    public ResponseVo<String> uploadLogo(MultipartFile file) throws Exception {
        FileStoreItem item = this.fileStoreManager.save(null, file.getBytes(), "png", false, Float.valueOf(1.0f));
        this.settingService.update("\u81ea\u5b9a\u4e49logo", "logoUrl", "/pisces/fileStore/getFile?uuid=" + item.getFileUUID(), null, null);
        return ResponseVo.BUILDER().setData((Object)"success").setCode(Integer.valueOf(0));
    }

    private MenuTree buildUserMenu(SystemUser loginUser) {
        MenuTree mt = MenuFrameModule.menuTree.clone();
        this.checkMenus(mt.getRoot(), loginUser.getPermitUrlList());
        return mt;
    }

    private void checkMenus(List<SimpleMenu> menus, List<String> permitUrlList) {
        if (menus.isEmpty()) {
            return;
        }
        ArrayList<SimpleMenu> removed = new ArrayList<SimpleMenu>();
        for (SimpleMenu menu : menus) {
            if (!StringUtils.hasText((String)menu.getUrl())) {
                this.checkMenus(menu.getChildren(), permitUrlList);
                continue;
            }
            if (!permitUrlList.contains(menu.getUrl())) {
                removed.add(menu);
                continue;
            }
            this.checkMenus(menu.getChildren(), permitUrlList);
        }
        menus.removeAll(removed);
    }
}

