<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <script src="/assets/jquery/jquery-3.1.1.min.js"></script>
    <script src="/assets/layui-2.9.18/layui.js"></script>
    <link rel="stylesheet" href="/assets/layui-2.9.18/css/layui.css">
    <link rel="stylesheet" href="/assets/layui-2.9.18/css/admin.css">
    <script src="/assets/september/common.js"></script>
    <script src="/assets/september/htmlBuilder.js"></script>
    <script src="/assets/september/search.js"></script>
    <link rel="stylesheet" href="/assets/pages/list.css">
</head>
<body class="layui-layout-body">
<div id="LAY_app">
    <div class="layui-layout layui-layout-admin">
        <!-- 主体内容 -->
        <div class="layui-fluid">
            <div class="layui-card">
                <div class="layui-form layui-card-header layuiadmin-card-header-auto">
                    <div class="layui-form-item">
                        <div class="layui-form-item">
                            <div class="layui-inline">
                                <button class="layui-btn layuiadmin-btn-list" onclick="openAdd();">添加</button>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="layui-card-body">
                    <div id="form" class="layui-table-box layui-form" lay-filter="SystemRoleList">
                        <table id="LAY-app-content-list" lay-filter="LAY-app-content-list" class="layui-table">
                            <thead>
                            <tr>
                                <td align="center"><span>存储池名称</span></td>
                                <td align="center"><span>存储类型</span></td>
                                <td align="center"><span>存储路径</span></td>
                                <td align="center"><span>操作</span></td>
                            </tr>
                            </thead>
                            <tbody class="layui-table-body layui-table-main">
                            <tr class="data_row" style="display: none">
                                <td align="center"><span>$[poolName]</span></td>
                                <td align="center"><span script="true">getStoreType($[storeType])</span></td>
                                <td align="center"><span>$[diskPath]</span></td>
                                <td align="center" data-minwidth="150" class="layui-table-col-special">
                                    <div class="layui-table-cell">
                                        <a class="layui-btn layui-btn-normal layui-btn-xs"
                                           onclick="openEdit($[id])">编辑</a>
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="layui-card-body">
                        <div id="page"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- 主体内容结束-->
    </div>
</div>

<script type="text/javascript">
    searchUrl = '/pisces/fileStore/pool/listPoolData';
    layui.use(function () {
        var layer = layui.layer;
        doSearch(1);
    });

    function openAdd() {
        layer.open({
            maxmin: true,
            type: 2,
            title: '添加存储池',
            area: ['60%', '500px'],
            content: '/pisces/fileStore/pool/addPool'
        });
    }

    function openEdit(id) {
        layer.open({
            maxmin: true,
            type: 2,
            title: '编辑存储池',
            area: ['60%', '500px'],
            content: '/pisces/fileStore/pool/editPool?id=' + id
        });
    }

    function getStoreType(type) {

        if (type == 1) {
            return '磁盘';
        } else if (type == 2) {
            return 'OSS';
        } else if (type == 3) {
            return 'FTP';
        } else if (type == 4) {
            return '海康';
        } else {
            return '其他';
        }
    }

</script>

</body>
</html>
