/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.filestore.service;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.september.core.component.log.LogHelper;
import org.september.core.exception.BusinessException;
import org.september.pisces.filestore.api.FileStoreService;
import org.september.pisces.filestore.entity.FileStoreItem;
import org.september.pisces.filestore.entity.FileStorePool;
import org.springframework.stereotype.Service;

@Service
public class DiskFileStoreService
implements FileStoreService {
    protected LogHelper log = LogHelper.getLogger(this.getClass());
    public static final String Path_Prefix = File.separator + "file" + File.separator;

    @Override
    public String saveWithThumb(FileStorePool pool, byte[] data, String ext, boolean needThumb, float thumbRate) {
        SimpleDateFormat yyyy_MM_dd_HH = new SimpleDateFormat("yyyy-MM-dd-HH");
        String path = yyyy_MM_dd_HH.format(new Date());
        CharSequence[] arr = path.split("-");
        if (!((String)ext).startsWith(".")) {
            ext = "." + (String)ext;
        }
        String relativePath = String.join((CharSequence)File.separator, arr) + File.separator + String.valueOf(UUID.randomUUID()) + (String)ext;
        String filename = pool.getDiskPath() + File.separator + relativePath;
        try {
            File file = new File(filename);
            file.getParentFile().mkdirs();
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            if (needThumb) {
                File thumbnail = FileUtil.touch((String)(file.getAbsolutePath() + ".thumb" + (String)ext));
                ImgUtil.scale((File)file, (File)thumbnail, (float)thumbRate);
            }
            return Path_Prefix + pool.getPoolName() + File.separator + relativePath;
        }
        catch (Exception e) {
            throw new BusinessException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public String save(FileStorePool pool, byte[] data, String ext) {
        return this.saveWithThumb(pool, data, ext, false, 0.0f);
    }

    @Override
    public String getHttpPath(String uuid) {
        return null;
    }

    @Override
    public InputStream getInputStream(FileStorePool pool, FileStoreItem item, boolean thumb) {
        String path = item.getPath().replaceFirst(File.separator + Path_Prefix + File.separator + pool.getPoolName(), "");
        String filePath = pool.getDiskPath() + path;
        if (thumb) {
            filePath = filePath + ".thumb" + item.getExt();
        }
        try {
            return FileUtils.openInputStream((File)new File(filePath));
        }
        catch (IOException e) {
            throw new BusinessException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean deleteFile(FileStorePool pool, FileStoreItem item) {
        String path = item.getPath().replaceFirst(File.separator + Path_Prefix + File.separator + pool.getPoolName(), "");
        String filePath = pool.getDiskPath() + path;
        boolean result = FileUtils.deleteQuietly((File)new File(filePath));
        if (!result) {
            this.log.getBuilder().warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + filePath);
        }
        return result;
    }
}

