/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.cache.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.september.core.util.RamUsageUtil;
import org.september.pisces.cache.vo.CacheVo;
import org.springframework.stereotype.Service;

@Service
public class ExpirableCacheService2 {
    private Map<String, CacheVo> data = new ConcurrentHashMap<String, CacheVo>();
    private Map<String, Long> expiredTime = new ConcurrentHashMap<String, Long>();

    public ExpirableCacheService2() {
        this.autoClear();
    }

    public void set(String key, Object obj, int timeout, boolean autoRefresh, String remark) {
        CacheVo vo = new CacheVo(key, obj, remark, timeout, autoRefresh);
        vo.setAddTime(new Date());
        this.data.put(key, vo);
        this.expiredTime.put(key, System.currentTimeMillis() + (long)(timeout * 1000));
    }

    public CacheVo get(String key) {
        CacheVo cache = this.data.get(key);
        if (cache != null) {
            return cache;
        }
        return null;
    }

    public boolean has(String url) {
        return this.data.containsKey(url);
    }

    public void remove(String key) {
        this.expiredTime.remove(key);
        this.data.remove(key);
    }

    public List<CacheVo> toList() {
        ArrayList<CacheVo> caches = new ArrayList<CacheVo>();
        for (String key : this.data.keySet()) {
            CacheVo cache = this.data.get(key);
            if (cache == null) continue;
            int left = (int)(cache.getExpireTime().getTime() - System.currentTimeMillis()) / 1000;
            if (left <= 0) {
                left = 0;
            }
            cache.setLeftSeconds(left);
            cache.setSize(RamUsageUtil.sizeOfObject((Object)cache.getTarget()));
            caches.add(cache);
        }
        return caches;
    }

    private void autoClear() {
        Thread t = new Thread(){

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Iterator<String> iterator = ExpirableCacheService2.this.data.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        String key = iterator.next();
                        CacheVo vo = ExpirableCacheService2.this.get(key);
                        if (vo == null || !vo.isExpired() || vo.isAutoRefresh()) continue;
                        ExpirableCacheService2.this.remove(key);
                    }
                    break;
                }
            }
        };
        t.setName("ExpirableCacheService-check-thread");
        t.start();
    }
}

