/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.cache.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.september.core.exception.BusinessException;
import org.september.pisces.cache.aop.SimpleCache;
import org.september.pisces.cache.service.ExpirableCacheService2;
import org.september.pisces.cache.vo.CacheVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CommonCacheAspect {
    @Autowired
    private ExpirableCacheService2 expirableCacheService2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.september.pisces.cache.aop.SimpleCache)")
    public Object process(final ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature ms = (MethodSignature)joinPoint.getSignature();
        final SimpleCache anno = ms.getMethod().getDeclaredAnnotation(SimpleCache.class);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < ms.getParameterNames().length; ++i) {
            String argName = ms.getParameterNames()[i];
            sb.append(argName).append("=").append(joinPoint.getArgs()[i]);
            if (i >= ms.getParameterNames().length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        final String key = joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName() + sb.toString();
        if (this.expirableCacheService2.has(key)) {
            final CacheVo cacheVo = this.expirableCacheService2.get(key);
            if (cacheVo.isExpired()) {
                if (anno.autoRefresh()) {
                    if (!cacheVo.isUpdating()) {
                        CacheVo cacheVo2 = cacheVo;
                        synchronized (cacheVo2) {
                            cacheVo.setUpdating(true);
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        CommonCacheAspect.this.processAndUpdateCache(joinPoint, key, anno);
                                        cacheVo.setUpdating(false);
                                    }
                                    catch (Throwable e) {
                                        throw new BusinessException("", e);
                                    }
                                }
                            }.start();
                        }
                    }
                    return cacheVo.getTarget();
                }
                return this.processAndUpdateCache(joinPoint, key, anno);
            }
            return cacheVo.getTarget();
        }
        return this.processAndUpdateCache(joinPoint, key, anno);
    }

    private Object processAndUpdateCache(ProceedingJoinPoint joinPoint, String key, SimpleCache anno) throws Throwable {
        Object obj = joinPoint.proceed();
        this.expirableCacheService2.set(key, obj, anno.timeoutSec(), anno.autoRefresh(), String.valueOf(obj));
        return obj;
    }
}

