/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.datasource;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.september.core.exception.BusinessException;
import org.september.smartdao.datasource.MyDataSource;
import org.september.smartdao.datasource.SmartRoutingDataSource;
import org.september.smartdao.datasource.config.DataSourceGroup;
import org.september.smartdao.datasource.config.DataSourceProperty;
import org.september.smartdao.util.DataSourceUtil;
import org.springframework.util.StringUtils;

public class SmartDatasourceHolder {
    private static Map<String, DataSourceGroup> dsGroupMap = new HashMap<String, DataSourceGroup>();
    private static ThreadLocal<String> currentDataSourceGroup = new ThreadLocal();
    private static ThreadLocal<Boolean> isReadonly = new ThreadLocal();
    private static SmartDatasourceHolder instance = new SmartDatasourceHolder();
    private static ThreadLocal<Boolean> datasourceLock = new ThreadLocal();
    private static Random rand = new Random();
    public static SmartRoutingDataSource srds;
    public static String defaultDatasourceGroup;

    static {
        defaultDatasourceGroup = "";
    }

    private SmartDatasourceHolder() {
    }

    public static String getDataSourceKey() {
        String key = currentDataSourceGroup.get();
        if (key == null) {
            key = defaultDatasourceGroup;
        }
        DataSourceGroup group = dsGroupMap.get(key);
        if (isReadonly.get() != null && isReadonly.get().booleanValue()) {
            int num = rand.nextInt(1000);
            return group.getName() + "-read-" + num % group.getReadDSList().size();
        }
        return group.getName() + "-write";
    }

    public static MyDataSource getCurrentDataSource() {
        String key = currentDataSourceGroup.get();
        if (key == null) {
            key = defaultDatasourceGroup;
        }
        DataSourceGroup group = dsGroupMap.get(key);
        return group.getWriteDS();
    }

    public static void switchToWrite() {
        if (datasourceLock.get() == null || !datasourceLock.get().booleanValue()) {
            isReadonly.set(false);
        }
    }

    public static void switchToRead() {
        if (datasourceLock.get() == null || !datasourceLock.get().booleanValue()) {
            isReadonly.set(true);
        }
    }

    public static void setDataSourceGroup(String group) {
        if (datasourceLock.get() == null || !datasourceLock.get().booleanValue()) {
            currentDataSourceGroup.set(group);
        }
    }

    public static void addMySQLDataSource(String groupName, String jdbcUrl, String username, String password, String driver) {
        if (!StringUtils.hasText((String)groupName)) {
            throw new BusinessException("\u6570\u636e\u6e90\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataSourceGroup group = new DataSourceGroup();
        group.setName(groupName);
        DataSourceProperty dsp = new DataSourceProperty();
        dsp.setJdbcUrl(jdbcUrl);
        dsp.setDriverClass(driver);
        dsp.setUsername(username);
        dsp.setPassword(password);
        MyDataSource ds = new MyDataSource();
        DataSourceUtil.copyProps(dsp, ds);
        group.setWriteDS(ds);
        group.getReadDSList().add(ds);
        dsGroupMap.put(groupName, group);
        srds.addDataSourceGroup(group);
        if ("".equals(defaultDatasourceGroup)) {
            defaultDatasourceGroup = groupName;
        }
    }

    public static void removeDataSource(String name) {
        dsGroupMap.remove(name);
    }

    public static SmartDatasourceHolder getInstance() {
        return instance;
    }

    public void setDataSourceGroupMap(Map<String, DataSourceGroup> map) {
        dsGroupMap = map;
    }

    public static void lockDataSource() {
        datasourceLock.set(true);
    }

    public static void releaseDataSourceLock() {
        datasourceLock.set(false);
    }

    public static Collection<DataSourceGroup> getDataSourceGroups() {
        return dsGroupMap.values();
    }
}

