/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.september.core.component.log.LogHelper;
import org.september.smartdao.CommonDaoHolder;
import org.september.smartdao.config.FieldDataConverter;

public class ReflectHelper {
    private static final LogHelper logger = LogHelper.getLogger(ReflectHelper.class);

    public static Map<String, Object> transEmptyString2Null(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field f : ReflectHelper.getAllDeclaredFields(obj.getClass())) {
            f.setAccessible(true);
            try {
                Object value = f.get(obj);
                if (value == null) continue;
                if ("".equals(value)) {
                    map.put(f.getName(), null);
                    continue;
                }
                map.put(f.getName(), value);
            }
            catch (Exception e) {
                logger.getBuilder().warn("get " + f.getName() + " value of " + obj.getClass().getName() + " failed ");
            }
        }
        return map;
    }

    public static <T> List<T> transformMapToEntity(Class<T> clazz, List<Map<String, Object>> mapResult) {
        ArrayList<T> entityResult = new ArrayList<T>();
        for (Map<String, Object> map : mapResult) {
            entityResult.add(ReflectHelper.transformMapToEntity(clazz, map));
        }
        return entityResult;
    }

    private static void setProperties(Object dest, Map<String, Object> origin) throws IllegalArgumentException, IllegalAccessException {
        origin = CommonDaoHolder.getCommonDao().getSqlHelper().dbFieldToEntityField(dest.getClass(), origin);
        Field[] fieldList = ReflectHelper.getAllDeclaredFields(dest.getClass());
        Object value = null;
        for (Field field : fieldList) {
            try {
                Timestamp timestamp;
                String name = field.getName();
                value = origin.get(name);
                if (value == null) {
                    value = origin.get(name.toUpperCase());
                }
                field.setAccessible(true);
                if (value == null) continue;
                FieldDataConverter converter = CommonDaoHolder.getCommonDao().getFieldDataConverter();
                if (converter != null) {
                    value = converter.convert(value);
                }
                if (field.getType().equals(Character.class) || field.getClass().equals(Character.TYPE)) {
                    String str = (String)value;
                    if (str.length() <= 0) continue;
                    field.set(dest, Character.valueOf(str.charAt(0)));
                    continue;
                }
                if (field.getType().equals(Instant.class)) {
                    timestamp = (Timestamp)value;
                    field.set(dest, timestamp.toInstant());
                    continue;
                }
                if (field.getType().equals(LocalDateTime.class)) {
                    timestamp = (Timestamp)value;
                    field.set(dest, timestamp.toLocalDateTime());
                    continue;
                }
                if (field.getType().equals(LocalDate.class)) {
                    Date date = (Date)value;
                    field.set(dest, date.toLocalDate());
                    continue;
                }
                if (field.getType().equals(LocalTime.class)) {
                    Time time = (Time)value;
                    field.set(dest, time.toLocalTime());
                    continue;
                }
                if (field.getType().equals(ZonedDateTime.class)) {
                    timestamp = (Timestamp)value;
                    field.set(dest, OffsetDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()));
                    continue;
                }
                if (value instanceof Timestamp) {
                    Timestamp tvalue = (Timestamp)value;
                    field.set(dest, new java.util.Date(tvalue.getTime()));
                    continue;
                }
                if (value instanceof LocalDateTime) {
                    Timestamp ts = Timestamp.valueOf((LocalDateTime)value);
                    field.set(dest, new java.util.Date(ts.getTime()));
                    continue;
                }
                if (field.getType().isEnum()) {
                    field.set(dest, field.getType().getEnumConstants()[(Integer)value]);
                    continue;
                }
                if (value instanceof Short) {
                    Short v = (Short)value;
                    if (field.getType().equals(Integer.class)) {
                        field.set(dest, v.intValue());
                        continue;
                    }
                    field.set(dest, v);
                    continue;
                }
                field.set(dest, value);
            }
            catch (Exception ex) {
                throw new RuntimeException("field type convert error", ex);
            }
        }
    }

    public static <T> T transformMapToEntity(Class<T> clazz, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            T entity = clazz.newInstance();
            ReflectHelper.setProperties(entity, map);
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException("try to wrap entity " + clazz.getName() + " failed", e);
        }
    }

    public static Field[] getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> target = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            target.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return target.toArray(new Field[0]);
    }

    public static boolean isTransientField(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }
}

