/*
 * Decompiled with CFR 0.152.
 */
package org.september.smartdao.datasource.config;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.september.core.component.log.LogHelper;
import org.september.smartdao.config.CustomizeDataSourcePropertyProvider;
import org.september.smartdao.datasource.MyDataSource;
import org.september.smartdao.datasource.SmartDatasourceHolder;
import org.september.smartdao.datasource.SmartRoutingDataSource;
import org.september.smartdao.datasource.config.DataSourceGroup;
import org.september.smartdao.datasource.config.DataSourceProperty;
import org.september.smartdao.util.DataSourceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(prefix="spring.alliance.dao")
public class SmartDaoDataSourceConfig {
    private LogHelper logHelper = LogHelper.getLogger(this.getClass());
    private List<DataSourceProperty> datasource;
    private String dialect;
    @Autowired(required=false)
    private CustomizeDataSourcePropertyProvider customizeDataSourcePropertyProvider;

    @Bean(name={"dataSource"}, initMethod="init")
    public SmartRoutingDataSource dataSource() {
        DataSourceGroup group;
        SmartRoutingDataSource srds = new SmartRoutingDataSource();
        HashMap<CallSite, MyDataSource> dsMap = new HashMap<CallSite, MyDataSource>();
        srds.setTargetDataSources(dsMap);
        if (this.dialect == null) {
            if (this.customizeDataSourcePropertyProvider == null) {
                throw new RuntimeException("forgot to config a dialect by spring.alliance.dao.dialect ?");
            }
            this.dialect = this.customizeDataSourcePropertyProvider.getDialect();
        }
        srds.setDialect(this.dialect);
        if (this.datasource == null || this.datasource.isEmpty()) {
            this.datasource = new ArrayList<DataSourceProperty>();
            if (this.customizeDataSourcePropertyProvider == null) {
                this.logHelper.getBuilder().info("forgot to config a datasource?");
            } else {
                this.datasource.add(this.customizeDataSourcePropertyProvider.getDataSourceProperty());
            }
        }
        srds.setDataSourcePropertys(this.datasource);
        HashMap<String, DataSourceGroup> dsGroupsMap = new HashMap<String, DataSourceGroup>();
        for (DataSourceProperty dsp : this.datasource) {
            if (StringUtils.isEmpty((Object)dsp.getGroup())) {
                throw new RuntimeException("datasource.group can not be empty");
            }
            if (!dsGroupsMap.containsKey(dsp.getGroup())) {
                DataSourceGroup dsg = new DataSourceGroup();
                dsg.setName(dsp.getGroup());
                dsGroupsMap.put(dsg.getName(), dsg);
            }
            group = (DataSourceGroup)dsGroupsMap.get(dsp.getGroup());
            MyDataSource ds = new MyDataSource();
            DataSourceUtil.copyProps(dsp, ds);
            if (dsp.getType() != null) {
                if (dsp.getType().contains("read")) {
                    group.getReadDSList().add(ds);
                }
                if (!dsp.getType().contains("write")) continue;
                group.setWriteDS(ds);
                continue;
            }
            throw new RuntimeException("datasource type can not be empty, must be read, write, or read/write.");
        }
        for (String key : dsGroupsMap.keySet()) {
            group = (DataSourceGroup)dsGroupsMap.get(key);
            if (group.getWriteDS() != null) {
                dsMap.put((CallSite)((Object)(group.getName() + "-write")), group.getWriteDS());
            }
            for (int i = 0; i < group.getReadDSList().size(); ++i) {
                dsMap.put((CallSite)((Object)(group.getName() + "-read-" + i)), group.getReadDSList().get(i));
            }
        }
        SmartDatasourceHolder.getInstance().setDataSourceGroupMap(dsGroupsMap);
        if (!dsGroupsMap.isEmpty()) {
            SmartDatasourceHolder.defaultDatasourceGroup = (String)dsGroupsMap.keySet().iterator().next();
        }
        SmartDatasourceHolder.srds = srds;
        return srds;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDatasource(List<DataSourceProperty> datasource) {
        this.datasource = datasource;
    }
}

