/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.websocket;

import com.dji.sdk.websocket.BizCodeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Schema(description="The format of WebSocket messages that the pilot can receive.")
public class WebSocketMessageResponse<T> {
    @JsonProperty(value="biz_code")
    @NotNull
    @Schema(description="webSocket messages identity", implementation=BizCodeEnum.class)
    private String bizCode;
    @Schema(description="webSocket messages version")
    private String version = "1.0";
    @NotNull
    @Min(value=123456789012L)
    @Schema(description="timestamp (milliseconds)")
    private @NotNull @Min(value=123456789012L) Long timestamp;
    @NotNull
    @Schema(description="Data corresponding to business functions")
    private T data;

    public String toString() {
        return "WebSocketMessageResponse{bizCode=" + this.bizCode + ", version='" + this.version + "', timestamp=" + this.timestamp + ", data=" + this.data + "}";
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public WebSocketMessageResponse<T> setBizCode(String bizCode) {
        this.bizCode = bizCode;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public WebSocketMessageResponse<T> setVersion(String version) {
        this.version = version;
        return this;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public WebSocketMessageResponse<T> setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public WebSocketMessageResponse<T> setData(T data) {
        this.data = data;
        return this;
    }
}

