/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.state;

import com.dji.sdk.common.Common;
import com.dji.sdk.common.SDKManager;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttGatewayPublish;
import com.dji.sdk.mqtt.state.DockStateDataKeyEnum;
import com.dji.sdk.mqtt.state.RcStateDataKeyEnum;
import com.dji.sdk.mqtt.state.StateDataKeyEnum;
import com.dji.sdk.mqtt.state.TopicStateRequest;
import com.dji.sdk.mqtt.state.TopicStateResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.RouterSpec;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

@Configuration
public class StateRouter {
    @Resource
    private MqttGatewayPublish gatewayPublish;

    @Bean
    public IntegrationFlow stateDataRouterFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)"inboundState").transform(Message.class, source -> {
            try {
                TopicStateRequest response = (TopicStateRequest)Common.getObjectMapper().readValue((byte[])source.getPayload(), (TypeReference)new TypeReference<TopicStateRequest>(){});
                String topic = String.valueOf(source.getHeaders().get((Object)"mqtt_receivedTopic"));
                String from = topic.substring("thing/product/".length(), topic.indexOf("/state"));
                return response.setFrom(from).setData(Common.getObjectMapper().convertValue(response.getData(), this.getTypeReference(response.getGateway(), response.getData())));
            }
            catch (IOException e) {
                throw new CloudSDKException(e);
            }
        }, null)).route(response -> StateDataKeyEnum.find(response.getData().getClass()), mapping -> Arrays.stream(StateDataKeyEnum.values()).forEach(key -> {
            RouterSpec routerSpec2 = mapping.channelMapping((Object)key, key.getChannelName());
        }))).get();
    }

    @Bean
    public IntegrationFlow replySuccessState() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((String)"outboundState").handle(this::publish)).nullChannel();
    }

    private TopicStateResponse publish(TopicStateResponse request, MessageHeaders headers) {
        if (Objects.isNull(request) || Objects.isNull(request.getData())) {
            return null;
        }
        this.gatewayPublish.publishReply(request, headers);
        return request;
    }

    private Class getTypeReference(String gatewaySn, Object data) {
        Set<String> keys = ((Map)data).keySet();
        String key = (String)keys.iterator().next();
        if (key.equals("payloads")) {
            System.err.println(data);
        } else if (key.equals("psdk_ui_resource")) {
            System.err.println(data);
        } else if (key.equals("psdk_widget_values")) {
            System.err.println(data);
        }
        switch (SDKManager.getDeviceSDK(gatewaySn).getType()) {
            case RC: {
                return RcStateDataKeyEnum.find(keys).getClassType();
            }
            case DOCK: 
            case DOCK2: 
            case DOCK3: {
                try {
                    return DockStateDataKeyEnum.find(keys).getClassType();
                }
                catch (CloudSDKException ex) {
                    System.err.println("-----------------,data=" + String.valueOf(data));
                    throw ex;
                }
            }
        }
        throw new CloudSDKException(CloudSDKErrorEnum.WRONG_DATA, "Unexpected value: " + String.valueOf((Object)SDKManager.getDeviceSDK(gatewaySn).getType()));
    }
}

