/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.services;

import com.dji.sdk.cloudapi.log.FileUploadListResponse;
import com.dji.sdk.cloudapi.log.LogMethodEnum;
import com.dji.sdk.common.Common;
import com.dji.sdk.mqtt.Chan;
import com.dji.sdk.mqtt.services.ServicesReplyReceiver;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class ServicesReplyHandler {
    @ServiceActivator(inputChannel="inboundServicesReply")
    public void servicesReply(Message<?> message) throws IOException {
        byte[] payload = (byte[])message.getPayload();
        TopicServicesResponse receiver = (TopicServicesResponse)Common.getObjectMapper().readValue(payload, (TypeReference)new TypeReference<TopicServicesResponse<ServicesReplyReceiver>>(){});
        Chan chan = Chan.getInstance(receiver.getTid(), false);
        if (Objects.isNull(chan)) {
            return;
        }
        if (LogMethodEnum.FILE_UPLOAD_LIST.getMethod().equals(receiver.getMethod())) {
            ((ServicesReplyReceiver)receiver.getData()).setOutput(Common.getObjectMapper().convertValue(receiver.getData(), (TypeReference)new TypeReference<FileUploadListResponse>(){}));
        }
        chan.put(receiver);
    }
}

