/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.events;

import com.dji.sdk.cloudapi.airsense.AirsenseWarning;
import com.dji.sdk.cloudapi.control.CameraPhotoTakeProgress;
import com.dji.sdk.cloudapi.control.DrcStatusNotify;
import com.dji.sdk.cloudapi.control.FlyToPointProgress;
import com.dji.sdk.cloudapi.control.JoystickInvalidNotify;
import com.dji.sdk.cloudapi.control.PoiStatusNotify;
import com.dji.sdk.cloudapi.control.TakeoffToPointProgress;
import com.dji.sdk.cloudapi.debug.RemoteDebugProgress;
import com.dji.sdk.cloudapi.firmware.OtaProgress;
import com.dji.sdk.cloudapi.flightarea.FlightAreasDroneLocation;
import com.dji.sdk.cloudapi.flightarea.FlightAreasSyncProgress;
import com.dji.sdk.cloudapi.hms.Hms;
import com.dji.sdk.cloudapi.interconnection.CustomDataTransmissionFromEsdk;
import com.dji.sdk.cloudapi.interconnection.CustomDataTransmissionFromPsdk;
import com.dji.sdk.cloudapi.log.FileUploadProgress;
import com.dji.sdk.cloudapi.map.OfflineMapSyncProgress;
import com.dji.sdk.cloudapi.media.FileUploadCallback;
import com.dji.sdk.cloudapi.media.HighestPriorityUploadFlightTaskMedia;
import com.dji.sdk.cloudapi.wayline.DeviceExitHomingNotify;
import com.dji.sdk.cloudapi.wayline.FlighttaskProgress;
import com.dji.sdk.cloudapi.wayline.FlighttaskReady;
import com.dji.sdk.cloudapi.wayline.ReturnHomeInfo;
import com.dji.sdk.mqtt.events.EventsDataRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.List;

public enum EventsMethodEnum {
    FLIGHTTASK_PROGRESS("flighttask_progress", "inboundEventsFlighttaskProgress", (TypeReference)new TypeReference<EventsDataRequest<FlighttaskProgress>>(){}),
    DEVICE_EXIT_HOMING_NOTIFY("device_exit_homing_notify", "inboundEventsDeviceExitHomingNotify", (TypeReference)new TypeReference<DeviceExitHomingNotify>(){}),
    FILE_UPLOAD_CALLBACK("file_upload_callback", "inboundEventsFileUploadCallback", (TypeReference)new TypeReference<FileUploadCallback>(){}),
    HMS("hms", "inboundEventsHms", (TypeReference)new TypeReference<Hms>(){}),
    DEVICE_REBOOT("device_reboot", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    DRONE_OPEN("drone_open", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    DRONE_CLOSE("drone_close", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    DRONE_FORMAT("drone_format", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    DEVICE_FORMAT("device_format", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    COVER_OPEN("cover_open", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    COVER_CLOSE("cover_close", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    PUTTER_OPEN("putter_open", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    PUTTER_CLOSE("putter_close", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    CHARGE_OPEN("charge_open", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    CHARGE_CLOSE("charge_close", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    ESIM_ACTIVATE("esim_activate", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    ESIM_OPERATOR_SWITCH("esim_operator_switch", "inboundEventsControlProgress", (TypeReference)new TypeReference<EventsDataRequest<RemoteDebugProgress>>(){}),
    OTA_PROGRESS("ota_progress", "inboundEventsOtaProgress", (TypeReference)new TypeReference<EventsDataRequest<OtaProgress>>(){}),
    FILE_UPLOAD_PROGRESS("fileupload_progress", "inboundEventsFileUploadProgress", (TypeReference)new TypeReference<EventsDataRequest<FileUploadProgress>>(){}),
    HIGHEST_PRIORITY_UPLOAD_FLIGHT_TASK_MEDIA("highest_priority_upload_flighttask_media", "inboundEventsHighestPriorityUploadFlightTaskMedia", (TypeReference)new TypeReference<HighestPriorityUploadFlightTaskMedia>(){}),
    FLIGHT_TASK_READY("flighttask_ready", "inboundEventsFlighttaskReady", (TypeReference)new TypeReference<FlighttaskReady>(){}),
    FLY_TO_POINT_PROGRESS("fly_to_point_progress", "inboundEventsFlyToPointProgress", (TypeReference)new TypeReference<FlyToPointProgress>(){}),
    TAKE_OFF_TO_POINT_PROGRESS("takeoff_to_point_progress", "inboundEventsTakeoffToPointProgress", (TypeReference)new TypeReference<TakeoffToPointProgress>(){}),
    DRC_STATUS_NOTIFY("drc_status_notify", "inboundEventsDrcStatusNotify", (TypeReference)new TypeReference<DrcStatusNotify>(){}),
    JOYSTICK_INVALID_NOTIFY("joystick_invalid_notify", "inboundEventsJoystickInvalidNotify", (TypeReference)new TypeReference<JoystickInvalidNotify>(){}),
    RETURN_HOME_INFO("return_home_info", "inboundEventsReturnHomeInfo", (TypeReference)new TypeReference<ReturnHomeInfo>(){}),
    CUSTOM_DATA_TRANSMISSION_FROM_ESDK("custom_data_transmission_from_esdk", "inboundEventsCustomDataTransmissionFromEsdk", (TypeReference)new TypeReference<CustomDataTransmissionFromEsdk>(){}),
    CUSTOM_DATA_TRANSMISSION_FROM_PSDK("custom_data_transmission_from_psdk", "inboundEventsCustomDataTransmissionFromPsdk", (TypeReference)new TypeReference<CustomDataTransmissionFromPsdk>(){}),
    AIRSENSE_WARNING("airsense_warning", "inboundEventsAirsenseWarning", (TypeReference)new TypeReference<List<AirsenseWarning>>(){}),
    FLIGHT_AREAS_SYNC_PROGRESS("flight_areas_sync_progress", "inboundEventsFlightAreasSyncProgress", (TypeReference)new TypeReference<FlightAreasSyncProgress>(){}),
    FLIGHT_AREAS_DRONE_LOCATION("flight_areas_drone_location", "inboundEventsFlightAreasDroneLocation", (TypeReference)new TypeReference<FlightAreasDroneLocation>(){}),
    OFFLINE_MAP_SYNC_PROGRESS("offline_map_sync_progress", "inboundEventsOfflineMapSyncProgress", (TypeReference)new TypeReference<OfflineMapSyncProgress>(){}),
    POI_STATUS_NOTIFY("poi_status_notify", "inboundEventsPoiStatusNotify", (TypeReference)new TypeReference<PoiStatusNotify>(){}),
    CAMERA_PHOTO_TAKE_PROGRESS("camera_photo_take_progress", "inboundEventsCameraPhotoTakeProgress", (TypeReference)new TypeReference<EventsDataRequest<CameraPhotoTakeProgress>>(){}),
    UNKNOWN("", "default", (TypeReference)new TypeReference<Object>(){});

    private final String method;
    private final String channelName;
    private final TypeReference classType;

    private EventsMethodEnum(String method, String channelName, TypeReference classType) {
        this.method = method;
        this.channelName = channelName;
        this.classType = classType;
    }

    public String getMethod() {
        return this.method;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public TypeReference getClassType() {
        return this.classType;
    }

    public static EventsMethodEnum find(String method) {
        return Arrays.stream(EventsMethodEnum.values()).filter(methodEnum -> methodEnum.method.equals(method)).findAny().orElse(UNKNOWN);
    }
}

