/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt.drc;

import com.dji.sdk.cloudapi.control.DelayInfoPush;
import com.dji.sdk.cloudapi.control.DroneControlResponse;
import com.dji.sdk.cloudapi.control.HeartBeatRequest;
import com.dji.sdk.cloudapi.control.HsiInfoPush;
import com.dji.sdk.cloudapi.control.OsdInfoPush;
import com.dji.sdk.mqtt.drc.DrcUpData;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;

public enum DrcUpMethodEnum {
    DRONE_CONTROL("drone_control", "inboundDrcUpDroneControl", (TypeReference)new TypeReference<DrcUpData<DroneControlResponse>>(){}),
    DRONE_EMERGENCY_STOP("drone_emergency_stop", "inboundDrcUpDroneEmergencyStop", (TypeReference)new TypeReference<DrcUpData>(){}),
    HEART_BEAT("heart_beat", "inboundDrcUpHeartBeat", (TypeReference)new TypeReference<HeartBeatRequest>(){}),
    HSI_INFO_PUSH("hsi_info_push", "inboundDrcUpHsiInfoPush", (TypeReference)new TypeReference<HsiInfoPush>(){}),
    DELAY_INFO_PUSH("delay_info_push", "inboundDrcUpDelayInfoPush", (TypeReference)new TypeReference<DelayInfoPush>(){}),
    OSD_INFO_PUSH("osd_info_push", "inboundDrcUpOsdInfoPush", (TypeReference)new TypeReference<OsdInfoPush>(){}),
    UNKNOWN("", "default", (TypeReference)new TypeReference<Object>(){});

    private final String method;
    private final String channelName;
    private final TypeReference classType;

    private DrcUpMethodEnum(String method, String channelName, TypeReference classType) {
        this.method = method;
        this.channelName = channelName;
        this.classType = classType;
    }

    public String getMethod() {
        return this.method;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public TypeReference getClassType() {
        return this.classType;
    }

    public static DrcUpMethodEnum find(String method) {
        return Arrays.stream(DrcUpMethodEnum.values()).filter(methodEnum -> methodEnum.method.equals(method)).findAny().orElse(UNKNOWN);
    }
}

