/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt;

import com.dji.sdk.common.Common;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.Chan;
import com.dji.sdk.mqtt.CommonTopicRequest;
import com.dji.sdk.mqtt.CommonTopicResponse;
import com.dji.sdk.mqtt.IMqttMessageGateway;
import com.dji.sdk.websocket.api.WebSocketMessageSend;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MqttGatewayPublish {
    private static final Logger log = LoggerFactory.getLogger(WebSocketMessageSend.class);
    private static final int DEFAULT_QOS = 0;
    public static final int DEFAULT_RETRY_COUNT = 2;
    public static final int DEFAULT_RETRY_TIMEOUT = 3000;
    @Resource
    private IMqttMessageGateway messageGateway;

    public void publish(String topic, int qos, CommonTopicRequest request) {
        try {
            log.debug("send topic: {}, payload: {}", (Object)topic, (Object)Common.getObjectMapper().writeValueAsString((Object)request));
            byte[] payload = Common.getObjectMapper().writeValueAsBytes((Object)request);
            this.messageGateway.publish(topic, payload, qos);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to publish the message. {}", (Object)request.toString());
            e.printStackTrace();
        }
    }

    public void publish(String topic, int qos, CommonTopicResponse response) {
        try {
            log.debug("send topic: {}, payload: {}", (Object)topic, (Object)response.toString());
            byte[] payload = Common.getObjectMapper().writeValueAsBytes((Object)response);
            this.messageGateway.publish(topic, payload, qos);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to publish the message. {}", (Object)response.toString());
            e.printStackTrace();
        }
    }

    public void publish(String topic, CommonTopicRequest request, int publishCount) {
        AtomicInteger time = new AtomicInteger(0);
        while (time.getAndIncrement() < publishCount) {
            this.publish(topic, 0, request);
        }
    }

    public void publish(String topic, CommonTopicRequest request) {
        this.publish(topic, 0, request);
    }

    public void publishReply(CommonTopicResponse response, MessageHeaders headers) {
        this.publish(headers.get((Object)"mqtt_receivedTopic") + "_reply", 2, response);
    }

    public <T> CommonTopicResponse<T> publishWithReply(Class<T> clazz, String topic, CommonTopicRequest request, int retryCount, long timeout) {
        AtomicInteger time = new AtomicInteger(0);
        boolean hasBid = StringUtils.hasText((String)request.getBid());
        request.setBid(hasBid ? request.getBid() : UUID.randomUUID().toString());
        while (time.getAndIncrement() <= retryCount) {
            this.publish(topic, request);
            CommonTopicResponse receiver = Chan.getInstance(request.getTid(), true).get(request.getTid(), timeout);
            if (Objects.nonNull(receiver) && receiver.getTid().equals(request.getTid()) && receiver.getBid().equals(request.getBid())) {
                if (clazz.isAssignableFrom(receiver.getData().getClass())) {
                    return receiver;
                }
                throw new TypeMismatchException(receiver.getData(), clazz);
            }
            if (!hasBid) {
                request.setBid(UUID.randomUUID().toString());
            }
            request.setTid(UUID.randomUUID().toString());
        }
        throw new CloudSDKException(CloudSDKErrorEnum.MQTT_PUBLISH_ABNORMAL, "No message reply received.");
    }
}

