/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt;

import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.converter.MessageConverter;

@Configuration
@IntegrationComponentScan
public class MqttConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MqttConfiguration.class);
    @Value(value="${cloud-sdk.mqtt.inbound-topic: }")
    private String inboundTopic;
    @Resource
    private MqttPahoClientFactory mqttClientFactory;
    @Resource(name="inbound")
    private MessageChannel inboundChannel;

    @Bean
    public MqttPahoMessageDrivenChannelAdapter mqttInbound() {
        MqttPahoMessageDrivenChannelAdapter adapter = new MqttPahoMessageDrivenChannelAdapter(UUID.randomUUID().toString(), this.mqttClientFactory, this.inboundTopic.split(","));
        DefaultPahoMessageConverter converter = new DefaultPahoMessageConverter();
        converter.setPayloadAsBytes(true);
        adapter.setConverter((MqttMessageConverter)converter);
        adapter.setQos(new int[]{1});
        adapter.setOutputChannel(this.inboundChannel);
        return adapter;
    }

    @Bean
    @ServiceActivator(inputChannel="outbound")
    public MessageHandler mqttOutbound() {
        MqttPahoMessageHandler messageHandler = new MqttPahoMessageHandler(UUID.randomUUID().toString(), this.mqttClientFactory);
        DefaultPahoMessageConverter converter = new DefaultPahoMessageConverter();
        converter.setPayloadAsBytes(true);
        messageHandler.setAsync(true);
        messageHandler.setDefaultQos(0);
        messageHandler.setConverter((MessageConverter)converter);
        return messageHandler;
    }

    @Bean
    @ServiceActivator(inputChannel="default")
    public MessageHandler defaultInboundHandler() {
        return message -> System.err.println("The default channel does not handle messages.\nTopic: " + message.getHeaders().get((Object)"mqtt_receivedTopic") + "\nPayload: " + message.getPayload() + "\n");
    }
}

