/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.mqtt;

import java.util.Arrays;
import java.util.regex.Pattern;

public enum CloudApiTopicEnum {
    STATUS(Pattern.compile("^sys/product/[A-Za-z0-9]+/status$"), "inboundStatus"),
    STATE(Pattern.compile("^thing/product/[A-Za-z0-9]+/state$"), "inboundState"),
    SERVICE_REPLY(Pattern.compile("^thing/product/[A-Za-z0-9]+/services_reply$"), "inboundServicesReply"),
    OSD(Pattern.compile("^thing/product/[A-Za-z0-9]+/osd$"), "inboundOsd"),
    REQUESTS(Pattern.compile("^thing/product/[A-Za-z0-9]+/requests$"), "inboundRequests"),
    EVENTS(Pattern.compile("^thing/product/[A-Za-z0-9]+/events$"), "inboundEvents"),
    PROPERTY_SET_REPLY(Pattern.compile("^thing/product/[A-Za-z0-9]+/property/set_reply$"), "inboundPropertySetReply"),
    DRC_UP(Pattern.compile("^thing/product/[A-Za-z0-9]+/drc/up$"), "inboundDrcUp"),
    UNKNOWN(Pattern.compile("^.*$"), "default");

    private final Pattern pattern;
    private final String beanName;

    private CloudApiTopicEnum(Pattern pattern, String beanName) {
        this.pattern = pattern;
        this.beanName = beanName;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public static CloudApiTopicEnum find(String topic) {
        return Arrays.stream(CloudApiTopicEnum.values()).filter(topicEnum -> topicEnum.pattern.matcher(topic).matches()).findAny().orElse(UNKNOWN);
    }
}

