/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.exception;

import com.dji.sdk.common.IErrorInfo;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import java.util.Arrays;

public class CloudSDKException
extends RuntimeException {
    private IErrorInfo errorInfo = CloudSDKErrorEnum.UNKNOWN;

    public CloudSDKException(String message) {
        super(message);
    }

    public CloudSDKException(Throwable cause) {
        super(cause);
    }

    public CloudSDKException() {
        this("SDK Exception");
        this.errorInfo = CloudSDKErrorEnum.UNKNOWN;
    }

    public CloudSDKException(Class clazz, Object ... code) {
        this(clazz.getName() + " has unknown data: " + Arrays.toString(code));
        this.errorInfo = CloudSDKErrorEnum.WRONG_DATA;
    }

    public CloudSDKException(IErrorInfo err) {
        this(err, null);
    }

    public CloudSDKException(IErrorInfo err, String msg) {
        this(String.format("Error Code: %d, Error Msg: %s. %s", err.getCode(), err.getMessage(), msg));
        this.errorInfo = err;
    }

    public IErrorInfo getErrorInfo() {
        return this.errorInfo;
    }
}

