/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.config.version;

import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.IThingVersion;
import com.dji.sdk.exception.CloudSDKVersionException;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum DockThingVersionEnum implements IThingVersion
{
    V1_0_0("1.0.0", CloudSDKVersionEnum.V0_0_1),
    V1_1_0("1.1.0", CloudSDKVersionEnum.V0_0_1),
    V1_1_2("1.1.2", CloudSDKVersionEnum.V1_0_0),
    V1_1_3("1.1.3", CloudSDKVersionEnum.V1_0_2);

    private final String thingVersion;
    private final CloudSDKVersionEnum cloudSDKVersion;

    private DockThingVersionEnum(String thingVersion, CloudSDKVersionEnum cloudSDKVersion) {
        this.thingVersion = thingVersion;
        this.cloudSDKVersion = cloudSDKVersion;
    }

    @Override
    @JsonValue
    public String getThingVersion() {
        return this.thingVersion;
    }

    @Override
    public CloudSDKVersionEnum getCloudSDKVersion() {
        return this.cloudSDKVersion;
    }

    public static DockThingVersionEnum find(String thingVersion) {
        return Arrays.stream(DockThingVersionEnum.values()).filter(thingVersionEnum -> thingVersionEnum.thingVersion.equals(thingVersion)).findAny().orElseThrow(() -> new CloudSDKVersionException(thingVersion));
    }
}

