/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.config;

import com.dji.sdk.common.Common;
import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.web.servlet.mvc.method.annotation.ExtendedServletRequestDataBinder;

public class GetSnakeDataBinder
extends ExtendedServletRequestDataBinder {
    public GetSnakeDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        List propertyValueList = mpvs.getPropertyValueList();
        ArrayList values = new ArrayList(propertyValueList);
        Field[] fields = this.getTarget().getClass().getDeclaredFields();
        Map<String, Field> fieldMap = Arrays.stream(fields).collect(Collectors.toMap(Field::getName, field -> field));
        fieldMap.putAll(Arrays.stream(fields).filter(field -> null != field.getAnnotation(JsonProperty.class)).collect(Collectors.toMap(field -> field.getAnnotation(JsonProperty.class).value(), field -> field)));
        for (PropertyValue property : values) {
            PropertyValue propertyValue;
            if (!fieldMap.containsKey(property.getName())) continue;
            Field field2 = fieldMap.get(property.getName());
            List list = Objects.requireNonNullElse(property.getConvertedValue(), new ArrayList());
            list.addAll((List)this.convertValue(field2, this.getTarget(), property.getValue()));
            property.setConvertedValue((Object)list);
            String fieldName = field2.getName();
            if (mpvs.contains(fieldName) && (propertyValue = mpvs.getPropertyValue(fieldName)) != property && null != propertyValue.getConvertedValue()) {
                ((List)propertyValue.getConvertedValue()).addAll((List)property.getConvertedValue());
                property = propertyValue;
            }
            Object data = Collection.class.isAssignableFrom(field2.getType()) ? property.getConvertedValue() : ((List)property.getConvertedValue()).get(0);
            mpvs.addPropertyValue(new PropertyValue(fieldName, Objects.requireNonNullElse(data, property.getValue())));
        }
        super.addBindValues(mpvs, request);
    }

    private Object convertValue(Field field, Object object, Object value) {
        ArrayList<Object> convertedValue = new ArrayList<Object>();
        if (Enum.class.isAssignableFrom(field.getType())) {
            convertedValue.add(this.getRealEnumValue(field.getType(), object, new Object[]{value}));
            return convertedValue;
        }
        if (field.getType() == field.getGenericType()) {
            convertedValue.add(value);
            return convertedValue;
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            if (!value.getClass().isArray()) {
                value = String.valueOf(value).split(",");
            }
            for (String v : (String[])value) {
                if ("".equals(v)) continue;
                convertedValue.add(this.getRealEnumValue((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], object, v));
            }
        }
        return convertedValue;
    }

    private Object getRealEnumValue(Class type, Object object, Object ... value) {
        if (!type.isEnum()) {
            return value;
        }
        Set methods = Arrays.stream(type.getDeclaredMethods()).filter(m -> null != m.getAnnotation(JsonCreator.class)).filter(m -> m.getParameterTypes().length == value.length).collect(Collectors.toSet());
        Iterator iterator = methods.iterator();
        if (iterator.hasNext()) {
            Method m2 = (Method)iterator.next();
            try {
                Class<?>[] parameterTypes = m2.getParameterTypes();
                for (int i = 0; i < value.length; ++i) {
                    value[i] = Common.getObjectMapper().convertValue(value[i], parameterTypes[i]);
                }
                return m2.invoke(object, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new CloudSDKException(e);
            }
        }
        return value;
    }
}

