/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline.api;

import com.dji.sdk.cloudapi.wayline.GetWaylineListRequest;
import com.dji.sdk.cloudapi.wayline.GetWaylineListResponse;
import com.dji.sdk.cloudapi.wayline.WaylineUploadCallbackRequest;
import com.dji.sdk.common.HttpResultResponse;
import com.dji.sdk.common.PaginationData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="wayline interface")
public interface IHttpWaylineService {
    public static final String PREFIX = "wayline/api/v1";

    @Operation(summary="get wayline list", description="Query the basic data of the wayline file according to the query conditions. The query condition field in pilot is fixed.", parameters={@Parameter(name="workspace_id", description="workspace id", schema=@Schema(format="uuid"))})
    @GetMapping(value={"wayline/api/v1/workspaces/{workspace_id}/waylines"})
    public HttpResultResponse<PaginationData<GetWaylineListResponse>> getWaylineList(@Valid @ParameterObject GetWaylineListRequest var1, @PathVariable(name="workspace_id") String var2, HttpServletRequest var3, HttpServletResponse var4);

    @Operation(summary="get wayline file download address", description="Query the download address of the file according to the wayline file id, and redirect to this address directly for download.", parameters={@Parameter(name="workspace_id", description="workspace id", schema=@Schema(format="uuid")), @Parameter(name="wayline_id", description="wayline id", schema=@Schema(format="uuid"))})
    @GetMapping(value={"wayline/api/v1/workspaces/{workspace_id}/waylines/{wayline_id}/url"})
    public void getWaylineFileDownloadAddress(@PathVariable(name="workspace_id") String var1, @PathVariable(name="wayline_id") String var2, HttpServletRequest var3, HttpServletResponse var4);

    @Operation(summary="get duplicated wayline name", description="Checking whether the name already exists according to the wayline name must ensure the uniqueness of the wayline name. This interface will be called when uploading waylines and must be available.", parameters={@Parameter(name="workspace_id", description="workspace id", required=true), @Parameter(name="name", description="wayline file name", required=true)})
    @GetMapping(value={"wayline/api/v1/workspaces/{workspace_id}/waylines/duplicate-names"})
    public HttpResultResponse<List<String>> getDuplicatedWaylineName(@PathVariable(name="workspace_id") String var1, @NotNull @Size(min=1) @RequestParam(name="name") @NotNull @Size(min=1) List<String> var2, HttpServletRequest var3, HttpServletResponse var4);

    @Operation(summary="file upload result report", description="When the wayline file is uploaded to the storage server by pilot, the basic information of the file is reported through this interface.", parameters={@Parameter(name="workspace_id", description="workspace id", required=true)})
    @PostMapping(value={"wayline/api/v1/workspaces/{workspace_id}/upload-callback"})
    public HttpResultResponse fileUploadResultReport(@PathVariable(name="workspace_id") String var1, @Valid @RequestBody WaylineUploadCallbackRequest var2, HttpServletRequest var3, HttpServletResponse var4);

    @Operation(summary="batch favorites wayline", description="Favorite the wayline file according to the wayline file id.", parameters={@Parameter(name="workspace_id", description="workspace id", required=true), @Parameter(name="id", description="wayline id", required=true)})
    @PostMapping(value={"wayline/api/v1/workspaces/{workspace_id}/favorites"})
    public HttpResultResponse batchFavoritesWayline(@PathVariable(name="workspace_id") String var1, @NotNull @Size(min=1) @RequestParam(name="id") @NotNull @Size(min=1) List<String> var2, HttpServletRequest var3, HttpServletResponse var4);

    @Operation(summary="batch unfavorites wayline", description="Delete the favorites of this wayline file based on the wayline file id.", parameters={@Parameter(name="workspace_id", description="workspace id", required=true), @Parameter(name="id", description="wayline id", required=true)})
    @DeleteMapping(value={"wayline/api/v1/workspaces/{workspace_id}/favorites"})
    public HttpResultResponse batchUnfavoritesWayline(@PathVariable(name="workspace_id") String var1, @NotNull @Size(min=1) @RequestParam(name="id") @NotNull @Size(min=1) List<String> var2, HttpServletRequest var3, HttpServletResponse var4);
}

