/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline.api;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.wayline.DeviceExitHomingNotify;
import com.dji.sdk.cloudapi.wayline.FlighttaskCreateRequest;
import com.dji.sdk.cloudapi.wayline.FlighttaskExecuteRequest;
import com.dji.sdk.cloudapi.wayline.FlighttaskPrepareRequest;
import com.dji.sdk.cloudapi.wayline.FlighttaskProgress;
import com.dji.sdk.cloudapi.wayline.FlighttaskReady;
import com.dji.sdk.cloudapi.wayline.FlighttaskResourceGetRequest;
import com.dji.sdk.cloudapi.wayline.FlighttaskResourceGetResponse;
import com.dji.sdk.cloudapi.wayline.FlighttaskUndoRequest;
import com.dji.sdk.cloudapi.wayline.ReturnHomeInfo;
import com.dji.sdk.cloudapi.wayline.TaskTypeEnum;
import com.dji.sdk.cloudapi.wayline.WaylineMethodEnum;
import com.dji.sdk.common.Common;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.config.version.GatewayTypeEnum;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.events.EventsDataRequest;
import com.dji.sdk.mqtt.events.TopicEventsRequest;
import com.dji.sdk.mqtt.events.TopicEventsResponse;
import com.dji.sdk.mqtt.requests.TopicRequestsRequest;
import com.dji.sdk.mqtt.requests.TopicRequestsResponse;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractWaylineService {
    @Resource
    private ServicesPublish servicesPublish;

    @ServiceActivator(inputChannel="inboundEventsDeviceExitHomingNotify", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> deviceExitHomingNotify(TopicEventsRequest<DeviceExitHomingNotify> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("deviceExitHomingNotify not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsFlighttaskProgress", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> flighttaskProgress(TopicEventsRequest<EventsDataRequest<FlighttaskProgress>> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flighttaskProgress not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsFlighttaskReady", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> flighttaskReady(TopicEventsRequest<FlighttaskReady> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flighttaskReady not implemented");
    }

    @CloudSDKVersion(deprecated=CloudSDKVersionEnum.V0_0_1, exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flighttaskCreate(GatewayManager gateway, FlighttaskCreateRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.FLIGHTTASK_CREATE.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flighttaskPrepare(GatewayManager gateway, FlighttaskPrepareRequest request) {
        this.validPrepareParam(request);
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.FLIGHTTASK_PREPARE.getMethod(), (Object)request, request.getFlightId());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flighttaskExecute(GatewayManager gateway, FlighttaskExecuteRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.FLIGHTTASK_EXECUTE.getMethod(), (Object)request, request.getFlightId());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flighttaskUndo(GatewayManager gateway, FlighttaskUndoRequest request) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.FLIGHTTASK_UNDO.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flighttaskPause(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.FLIGHTTASK_PAUSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> flighttaskRecovery(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.FLIGHTTASK_RECOVERY.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> returnHome(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.RETURN_HOME.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData> returnHomeCancel(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), WaylineMethodEnum.RETURN_HOME_CANCEL.getMethod());
    }

    @ServiceActivator(inputChannel="inboundRequestsFlightTaskResourceGet", outputChannel="outboundRequests")
    public TopicRequestsResponse<MqttReply<FlighttaskResourceGetResponse>> flighttaskResourceGet(TopicRequestsRequest<FlighttaskResourceGetRequest> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flighttaskResourceGet not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsReturnHomeInfo", outputChannel="outboundEvents")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_2_5)
    public TopicRequestsResponse<MqttReply> returnHomeInfo(TopicRequestsRequest<ReturnHomeInfo> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("returnHomeInfo not implemented");
    }

    public TopicEventsResponse<MqttReply> returnHomeInfo(TopicEventsRequest<ReturnHomeInfo> request, MessageHeaders headers) {
        System.err.println("_return_home_info_" + request.getData().toString());
        return new TopicEventsResponse().setData(MqttReply.success());
    }

    private void validPrepareParam(FlighttaskPrepareRequest request) {
        if (request.getExecuteTime() == null && (TaskTypeEnum.IMMEDIATE == request.getTaskType() || TaskTypeEnum.TIMED == request.getTaskType())) {
            throw new CloudSDKException(CloudSDKErrorEnum.INVALID_PARAMETER, "Execute time must not be null.");
        }
        if (TaskTypeEnum.CONDITIONAL == request.getTaskType()) {
            Common.validateModel(request.getReadyConditions());
        }
    }
}

