/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.cloudapi.device.DeviceEnum;
import com.dji.sdk.cloudapi.wayline.WaylineTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="Wayline file metadata")
public class WaylineUploadCallbackMetadata {
    @NotNull
    @Schema(description="drone device product enum", example="0-67-0")
    @JsonProperty(value="drone_model_key")
    private DeviceEnum droneModelKey;
    @NotNull
    @Size(min=1)
    @JsonProperty(value="payload_model_keys")
    @Schema(description="payload device product enum", example="[\"1-53-0\"]")
    private @NotNull @Size(min=1) List<DeviceEnum> payloadModelKeys;
    @NotNull
    @Size(min=1)
    @Schema(description="wayline template collection", example="[0]")
    @JsonProperty(value="template_types")
    private @NotNull @Size(min=1) List<WaylineTypeEnum> templateTypes;

    public String toString() {
        return "WaylineUploadCallbackMetadata{droneModelKey='" + String.valueOf((Object)this.droneModelKey) + "', payloadModelKeys=" + String.valueOf(this.payloadModelKeys) + ", templateTypes=" + String.valueOf(this.templateTypes) + "}";
    }

    public DeviceEnum getDroneModelKey() {
        return this.droneModelKey;
    }

    public WaylineUploadCallbackMetadata setDroneModelKey(DeviceEnum droneModelKey) {
        this.droneModelKey = droneModelKey;
        return this;
    }

    public List<DeviceEnum> getPayloadModelKeys() {
        return this.payloadModelKeys;
    }

    public WaylineUploadCallbackMetadata setPayloadModelKeys(List<DeviceEnum> payloadModelKeys) {
        this.payloadModelKeys = payloadModelKeys;
        return this;
    }

    public List<WaylineTypeEnum> getTemplateTypes() {
        return this.templateTypes;
    }

    public WaylineUploadCallbackMetadata setTemplateTypes(List<WaylineTypeEnum> templateTypes) {
        this.templateTypes = templateTypes;
        return this;
    }
}

