/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.cloudapi.device.DeviceEnum;
import com.dji.sdk.cloudapi.wayline.ActionTypeEnum;
import com.dji.sdk.cloudapi.wayline.GetWaylineListOrderBy;
import com.dji.sdk.cloudapi.wayline.WaylineTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description="Query parameter to get list of wayline files")
public class GetWaylineListRequest {
    @Parameter(name="favorited", description="Is the wayline file favorited?")
    private Boolean favorited;
    @NotNull
    @JsonProperty(value="order_by")
    @Parameter(name="order_by", description="sort field name", example="update_time desc", schema=@Schema(allowableValues={"name desc", "name asc", "update_time desc", "update_time asc", "create_time desc", "create_time asc"}))
    @Valid
    private GetWaylineListOrderBy orderBy;
    @Min(value=1L)
    @Parameter(name="page", description="current page", schema=@Schema(defaultValue="1", type="int"))
    private @Min(value=1L) int page = 1;
    @Min(value=1L)
    @JsonProperty(value="page_size")
    @Parameter(name="page_size", description="page size", schema=@Schema(defaultValue="10", type="int"))
    private @Min(value=1L) int pageSize = 10;
    @Size(min=1)
    @JsonProperty(value="template_type")
    @Parameter(name="template_type", description="wayline template type collection", example="[0]")
    private @Size(min=1) List<WaylineTypeEnum> templateType;
    @JsonProperty(value="action_type")
    @Parameter(name="action_type", description="wayline template type collection", example="1")
    private ActionTypeEnum actionType;
    @JsonProperty(value="drone_model_keys")
    @Schema(name="drone_model_keys", description="drone device product enum", example="[\"0-67-0\"]")
    private List<DeviceEnum> droneModelKeys;
    @JsonProperty(value="payload_model_key")
    @Schema(name="payload_model_key", description="payload device product enum", example="[\"1-53-0\"]")
    private List<DeviceEnum> payloadModelKey;
    @JsonProperty(value="key")
    @Schema(name="key", description="wayline file name", example="waypoint")
    private String key;

    public String toString() {
        return "GetWaylineListRequest{favorited=" + String.valueOf(this.favorited) + ", orderBy='" + String.valueOf(this.orderBy) + "', page=" + this.page + ", pageSize=" + this.pageSize + ", templateType=" + String.valueOf(this.templateType) + ", actionType=" + String.valueOf((Object)this.actionType) + ", droneModelKeys=" + String.valueOf(this.droneModelKeys) + ", payloadModelKey=" + String.valueOf(this.payloadModelKey) + ", key='" + this.key + "'}";
    }

    public Boolean getFavorited() {
        return this.favorited;
    }

    public GetWaylineListRequest setFavorited(Boolean favorited) {
        this.favorited = favorited;
        return this;
    }

    public GetWaylineListOrderBy getOrderBy() {
        return this.orderBy;
    }

    public GetWaylineListRequest setOrderBy(GetWaylineListOrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public GetWaylineListRequest setPage(int page) {
        this.page = page;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public GetWaylineListRequest setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public List<WaylineTypeEnum> getTemplateType() {
        return this.templateType;
    }

    public GetWaylineListRequest setTemplateType(List<WaylineTypeEnum> templateType) {
        this.templateType = templateType;
        return this;
    }

    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    public GetWaylineListRequest setActionType(ActionTypeEnum actionType) {
        this.actionType = actionType;
        return this;
    }

    public List<DeviceEnum> getDroneModelKeys() {
        return this.droneModelKeys;
    }

    public GetWaylineListRequest setDroneModelKeys(List<DeviceEnum> droneModelKeys) {
        this.droneModelKeys = droneModelKeys;
        return this;
    }

    public List<DeviceEnum> getPayloadModelKey() {
        return this.payloadModelKey;
    }

    public GetWaylineListRequest setPayloadModelKey(List<DeviceEnum> payloadModelKey) {
        this.payloadModelKey = payloadModelKey;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public GetWaylineListRequest setKey(String key) {
        this.key = key;
        return this;
    }
}

