/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.wayline;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.device.ExitWaylineWhenRcLostEnum;
import com.dji.sdk.cloudapi.wayline.ExecutableConditions;
import com.dji.sdk.cloudapi.wayline.FlighttaskBreakPoint;
import com.dji.sdk.cloudapi.wayline.FlighttaskFile;
import com.dji.sdk.cloudapi.wayline.OutOfControlActionEnum;
import com.dji.sdk.cloudapi.wayline.ReadyConditions;
import com.dji.sdk.cloudapi.wayline.RthModeEnum;
import com.dji.sdk.cloudapi.wayline.SimulateMission;
import com.dji.sdk.cloudapi.wayline.TaskTypeEnum;
import com.dji.sdk.cloudapi.wayline.WaylinePrecisionTypeEnum;
import com.dji.sdk.cloudapi.wayline.WaylineTypeEnum;
import com.dji.sdk.common.BaseModel;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayTypeEnum;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class FlighttaskPrepareRequest
extends BaseModel {
    @NotNull
    @Pattern(regexp="^[^<>:\"/|?*._\\\\]+$")
    private @NotNull @Pattern(regexp="^[^<>:\"/|?*._\\\\]+$") String flightId;
    @Min(value=123456789012L)
    private @Min(value=123456789012L) Long executeTime;
    @NotNull
    private TaskTypeEnum taskType;
    @NotNull
    private WaylineTypeEnum waylineType;
    @NotNull
    @Valid
    private FlighttaskFile file;
    @Valid
    private ReadyConditions readyConditions;
    @Valid
    private ExecutableConditions executableConditions;
    @Valid
    private FlighttaskBreakPoint breakPoint;
    @NotNull
    @Min(value=20L)
    @Max(value=1500L)
    private @NotNull @Min(value=20L) @Max(value=1500L) Integer rthAltitude;
    @NotNull
    private OutOfControlActionEnum outOfControlAction;
    @NotNull
    private ExitWaylineWhenRcLostEnum exitWaylineWhenRcLost;
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    private RthModeEnum rthMode = RthModeEnum.PRESET_HEIGHT;
    @Valid
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    private SimulateMission simulateMission;
    @NotNull
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_1, include={GatewayTypeEnum.DOCK2})
    private WaylinePrecisionTypeEnum waylinePrecisionType;

    public String toString() {
        return "FlighttaskPrepareRequest{flightId='" + this.flightId + "', executeTime=" + String.valueOf(this.executeTime) + ", taskType=" + String.valueOf((Object)this.taskType) + ", waylineType=" + String.valueOf((Object)this.waylineType) + ", file=" + String.valueOf(this.file) + ", readyConditions=" + String.valueOf(this.readyConditions) + ", executableConditions=" + String.valueOf(this.executableConditions) + ", breakPoint=" + String.valueOf(this.breakPoint) + ", rthAltitude=" + String.valueOf(this.rthAltitude) + ", outOfControlAction=" + String.valueOf((Object)this.outOfControlAction) + ", exitWaylineWhenRcLost=" + String.valueOf((Object)this.exitWaylineWhenRcLost) + ", rthMode=" + String.valueOf((Object)this.rthMode) + ", simulateMission=" + String.valueOf(this.simulateMission) + ", waylinePrecisionType=" + String.valueOf((Object)this.waylinePrecisionType) + "}";
    }

    public String getFlightId() {
        return this.flightId;
    }

    public FlighttaskPrepareRequest setFlightId(String flightId) {
        this.flightId = flightId;
        return this;
    }

    public Long getExecuteTime() {
        return this.executeTime;
    }

    public FlighttaskPrepareRequest setExecuteTime(Long executeTime) {
        this.executeTime = executeTime;
        return this;
    }

    public TaskTypeEnum getTaskType() {
        return this.taskType;
    }

    public FlighttaskPrepareRequest setTaskType(TaskTypeEnum taskType) {
        this.taskType = taskType;
        return this;
    }

    public WaylineTypeEnum getWaylineType() {
        return this.waylineType;
    }

    public FlighttaskPrepareRequest setWaylineType(WaylineTypeEnum waylineType) {
        this.waylineType = waylineType;
        return this;
    }

    public FlighttaskFile getFile() {
        return this.file;
    }

    public FlighttaskPrepareRequest setFile(FlighttaskFile file) {
        this.file = file;
        return this;
    }

    public ReadyConditions getReadyConditions() {
        return this.readyConditions;
    }

    public FlighttaskPrepareRequest setReadyConditions(ReadyConditions readyConditions) {
        this.readyConditions = readyConditions;
        return this;
    }

    public ExecutableConditions getExecutableConditions() {
        return this.executableConditions;
    }

    public FlighttaskPrepareRequest setExecutableConditions(ExecutableConditions executableConditions) {
        this.executableConditions = executableConditions;
        return this;
    }

    public FlighttaskBreakPoint getBreakPoint() {
        return this.breakPoint;
    }

    public FlighttaskPrepareRequest setBreakPoint(FlighttaskBreakPoint breakPoint) {
        this.breakPoint = breakPoint;
        return this;
    }

    public Integer getRthAltitude() {
        return this.rthAltitude;
    }

    public FlighttaskPrepareRequest setRthAltitude(Integer rthAltitude) {
        this.rthAltitude = rthAltitude;
        return this;
    }

    public OutOfControlActionEnum getOutOfControlAction() {
        return this.outOfControlAction;
    }

    public FlighttaskPrepareRequest setOutOfControlAction(OutOfControlActionEnum outOfControlAction) {
        this.outOfControlAction = outOfControlAction;
        return this;
    }

    public ExitWaylineWhenRcLostEnum getExitWaylineWhenRcLost() {
        return this.exitWaylineWhenRcLost;
    }

    public FlighttaskPrepareRequest setExitWaylineWhenRcLost(ExitWaylineWhenRcLostEnum exitWaylineWhenRcLost) {
        this.exitWaylineWhenRcLost = exitWaylineWhenRcLost;
        return this;
    }

    public RthModeEnum getRthMode() {
        return this.rthMode;
    }

    public FlighttaskPrepareRequest setRthMode(RthModeEnum rthMode) {
        this.rthMode = rthMode;
        return this;
    }

    public SimulateMission getSimulateMission() {
        return this.simulateMission;
    }

    public FlighttaskPrepareRequest setSimulateMission(SimulateMission simulateMission) {
        this.simulateMission = simulateMission;
        return this;
    }

    public WaylinePrecisionTypeEnum getWaylinePrecisionType() {
        return this.waylinePrecisionType;
    }

    public FlighttaskPrepareRequest setWaylinePrecisionType(WaylinePrecisionTypeEnum waylinePrecisionType) {
        this.waylinePrecisionType = waylinePrecisionType;
        return this;
    }
}

