/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Schema(description="The token data of the temporary credential")
public class CredentialsToken {
    private static final int DELAY = 300;
    @NotNull
    @Schema(description="access key id", example="3POX6W77L1EF4C86L2RE")
    @JsonProperty(value="access_key_id")
    private String accessKeyId;
    @NotNull
    @Schema(description="access key secret", example="9NG2P2yJaUrck576CkdRoRbchKssJiZygi5D93CBsduY")
    @JsonProperty(value="access_key_secret")
    private String accessKeySecret;
    @NotNull
    @Min(value=1L)
    @Schema(description="The valid time of the token, in seconds.", example="3600")
    private @NotNull @Min(value=1L) Long expire;
    @NotNull
    @JsonProperty(value="security_token")
    @Schema(description="security token", example="eyJhbGciOiJIUzUxMiIsInR5cCI6IkpXVCJ9.eyJhY2Nlc3NLZXkiOiIzUE9YNlc3N0wxRUY0Qzg2TDJSRSIsImV4cCI6MTY4NjgxOTgyOSwicGFyZW50IjoibWluaW8ifQ.cWJXI90UidrBOTD0gWxKt8PT5Qp_6dEK5wNfJuE6lR9dH6Us7jtSB8vcttRDwPhpCNrAGsv91ydw6NLMyjqAOw")
    private String securityToken;

    public CredentialsToken(@NotNull String accessKeyId, @NotNull String accessKeySecret, @NotNull String securityToken, @NotNull @Min(value=1L) @NotNull @Min(value=1L) Long expire) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.expire = expire - 300L;
    }

    public CredentialsToken() {
    }

    public String toString() {
        return "CredentialsToken{accessKeyId='" + this.accessKeyId + "', accessKeySecret='" + this.accessKeySecret + "', expire=" + this.expire + ", securityToken='" + this.securityToken + "'}";
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public CredentialsToken setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public CredentialsToken setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
        return this;
    }

    public Long getExpire() {
        return this.expire;
    }

    public CredentialsToken setExpire(Long expire) {
        this.expire = expire;
        return this;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public CredentialsToken setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        return this;
    }
}

