/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.media;

import com.dji.sdk.cloudapi.media.MediaFileExtension;
import com.dji.sdk.cloudapi.media.MediaFileMetadata;
import com.dji.sdk.cloudapi.media.MediaSubFileTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(description="media fast upload request data")
public class MediaUploadCallbackRequest {
    @NotNull
    @Valid
    private MediaFileExtension ext;
    @NotNull
    @Schema(description="media file fingerprint", example="7F78C9F1999425CB61F10E1FE206009E")
    private String fingerprint;
    @NotNull
    @Schema(description="media file name", example="DJI_20220831151616_0004_W_Waypoint4.JPG")
    private String name;
    @Schema(description="media file path. This value is empty if the photo was not taken in the wayline.", example="DJI_202208311455_008_Waypoint1")
    private String path;
    @JsonProperty(value="object_key")
    @NotNull
    @Schema(description="The key of the object in the bucket", example="media/DJI_20220831151616_0004_W_Waypoint4.JPG")
    private String objectKey;
    @Schema(type="int")
    @JsonProperty(value="sub_file_type")
    @NotNull
    private MediaSubFileTypeEnum subFileType;
    @Valid
    @NotNull
    private MediaFileMetadata metadata;

    public String toString() {
        return "MediaUploadCallbackRequest{ext=" + String.valueOf(this.ext) + ", fingerprint='" + this.fingerprint + "', name='" + this.name + "', path='" + this.path + "', objectKey='" + this.objectKey + "', subFileType=" + String.valueOf((Object)this.subFileType) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public MediaFileExtension getExt() {
        return this.ext;
    }

    public MediaUploadCallbackRequest setExt(MediaFileExtension ext) {
        this.ext = ext;
        return this;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public MediaUploadCallbackRequest setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MediaUploadCallbackRequest setName(String name) {
        this.name = name;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public MediaUploadCallbackRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public MediaUploadCallbackRequest setObjectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    public MediaSubFileTypeEnum getSubFileType() {
        return this.subFileType;
    }

    public MediaUploadCallbackRequest setSubFileType(MediaSubFileTypeEnum subFileType) {
        this.subFileType = subFileType;
        return this;
    }

    public MediaFileMetadata getMetadata() {
        return this.metadata;
    }

    public MediaUploadCallbackRequest setMetadata(MediaFileMetadata metadata) {
        this.metadata = metadata;
        return this;
    }
}

