/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.media;

import com.dji.sdk.cloudapi.device.DeviceEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;

@Schema(description="media file upload callback extension data")
public class MediaFileExtension {
    @NotNull
    @JsonProperty(value="drone_model_key")
    @Schema(description="drone device product enum")
    private DeviceEnum droneModelKey;
    @NotNull
    @JsonProperty(value="file_group_id")
    @Schema(description="If the media file was shot during the wayline, this value will not be null.", format="uuid")
    private String fileGroupId;
    @JsonProperty(value="is_original")
    @NotNull
    @Schema(description="Whether the image is the original image.")
    private Boolean original;
    @NotNull
    @JsonProperty(value="payload_model_key")
    @Schema(description="payload device product enum", example="1-42-0")
    private DeviceEnum payloadModelKey;
    @NotNull
    @JsonProperty(value="tinny_fingerprint")
    @Schema(description="tiny fingerprint of the file.", example="297f490b0252690d3f93841818567cc6_2022_8_31_15_16_16")
    private String tinnyFingerprint;
    @NotNull
    @Schema(description="drone sn", example="1AD3CA2VL3LAD6")
    private String sn;

    public String toString() {
        return "MediaFileExtension{droneModelKey=" + String.valueOf((Object)this.droneModelKey) + ", fileGroupId='" + this.fileGroupId + "', original=" + String.valueOf(this.original) + ", payloadModelKey=" + String.valueOf((Object)this.payloadModelKey) + ", tinnyFingerprint='" + this.tinnyFingerprint + "', sn='" + this.sn + "'}";
    }

    public DeviceEnum getDroneModelKey() {
        return this.droneModelKey;
    }

    public MediaFileExtension setDroneModelKey(DeviceEnum droneModelKey) {
        this.droneModelKey = droneModelKey;
        return this;
    }

    public Boolean getOriginal() {
        return this.original;
    }

    public MediaFileExtension setOriginal(Boolean original) {
        this.original = original;
        return this;
    }

    public DeviceEnum getPayloadModelKey() {
        return this.payloadModelKey;
    }

    public MediaFileExtension setPayloadModelKey(DeviceEnum payloadModelKey) {
        this.payloadModelKey = payloadModelKey;
        return this;
    }

    public String getTinnyFingerprint() {
        return this.tinnyFingerprint;
    }

    public MediaFileExtension setTinnyFingerprint(String tinnyFingerprint) {
        this.tinnyFingerprint = tinnyFingerprint;
        return this;
    }

    public String getSn() {
        return this.sn;
    }

    public MediaFileExtension setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public String getFileGroupId() {
        return this.fileGroupId;
    }

    public MediaFileExtension setFileGroupId(String fileGroupId) {
        this.fileGroupId = fileGroupId;
        return this;
    }
}

