/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.media;

import com.dji.sdk.cloudapi.media.FastUploadExtension;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Schema(description="media fast upload request data")
public class MediaFastUploadRequest {
    @NotNull
    @Valid
    private FastUploadExtension ext;
    @NotNull
    @Schema(description="media file fingerprint", example="7F78C9F1999425CB61F10E1FE206009E")
    private String fingerprint;
    @NotNull
    @Schema(description="media file name", example="DJI_20220831151616_0004_W_Waypoint4.JPG")
    private String name;
    @Schema(description="media file path. This value is empty if the photo was not taken in the wayline.", example="DJI_202208311455_008_Waypoint1")
    private String path;

    public String toString() {
        return "MediaFastUploadRequest{ext=" + String.valueOf(this.ext) + ", fingerprint='" + this.fingerprint + "', name='" + this.name + "', path='" + this.path + "'}";
    }

    public FastUploadExtension getExt() {
        return this.ext;
    }

    public MediaFastUploadRequest setExt(FastUploadExtension ext) {
        this.ext = ext;
        return this;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public MediaFastUploadRequest setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MediaFastUploadRequest setName(String name) {
        this.name = name;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public MediaFastUploadRequest setPath(String path) {
        this.path = path;
        return this;
    }
}

