/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.map;

import com.dji.sdk.cloudapi.map.ElementResource;
import com.dji.sdk.common.BaseModel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@Schema(description="BizCode: map_element_create.<p>Websocket response data when element is created.</p>")
public class MapElementCreateWsResponse
extends BaseModel {
    @JsonProperty(value="group_id")
    @NotNull
    @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")
    @Schema(description="group id", format="uuid")
    private @NotNull @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$") String groupId;
    @NotNull
    @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")
    @Schema(description="element id", format="uuid")
    private @NotNull @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$") String id;
    @NotNull
    @Schema(description="element name", example="PILOT 1")
    private String name;
    @NotNull
    @Schema(description="element create time", example="123456789012")
    @JsonProperty(value="create_time")
    @Min(value=123456789012L)
    private @NotNull @Min(value=123456789012L) Long createTime;
    @NotNull
    @Schema(description="element update time", example="123456789012")
    @JsonProperty(value="update_time")
    @Min(value=123456789012L)
    private @NotNull @Min(value=123456789012L) Long updateTime;
    @NotNull
    @Valid
    private ElementResource resource;

    public String toString() {
        return "MapElementCreateWsResponse{groupId='" + this.groupId + "', id='" + this.id + "', name='" + this.name + "', createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", resource=" + this.resource + "}";
    }

    public String getId() {
        return this.id;
    }

    public MapElementCreateWsResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MapElementCreateWsResponse setName(String name) {
        this.name = name;
        return this;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public MapElementCreateWsResponse setCreateTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public MapElementCreateWsResponse setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public ElementResource getResource() {
        return this.resource;
    }

    public MapElementCreateWsResponse setResource(ElementResource resource) {
        this.resource = resource;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public MapElementCreateWsResponse setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }
}

