/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.map;

import com.dji.sdk.cloudapi.map.ElementCoordinate;
import com.dji.sdk.cloudapi.map.ElementGeometryType;
import com.dji.sdk.cloudapi.map.ElementResourceTypeEnum;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import com.dji.sdk.exception.CloudSDKException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.util.CollectionUtils;

@Schema(description="line geometry")
public class ElementLineStringGeometry
extends ElementGeometryType {
    @Schema(example="LineString")
    @NotNull
    private final String type = ElementResourceTypeEnum.LINE_STRING.getTypeName();
    @Schema(example="[[113.943109, 22.577378]]")
    @NotNull
    @Size(min=2)
    private @NotNull @Size(min=2) Double[][] coordinates;

    @Override
    public List<ElementCoordinate> convertToList() {
        if (this.coordinates.length < 2) {
            throw new CloudSDKException(CloudSDKErrorEnum.INVALID_PARAMETER);
        }
        ArrayList<ElementCoordinate> coordinateList = new ArrayList<ElementCoordinate>();
        for (Double[] coordinate : this.coordinates) {
            coordinateList.add(new ElementCoordinate().setLongitude(coordinate[0]).setLatitude(coordinate[1]));
        }
        return coordinateList;
    }

    @Override
    public void adapterCoordinateType(List<ElementCoordinate> coordinateList) {
        if (CollectionUtils.isEmpty(coordinateList) || coordinateList.size() < 2) {
            throw new CloudSDKException(CloudSDKErrorEnum.INVALID_PARAMETER);
        }
        this.coordinates = new Double[coordinateList.size()][2];
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i][0] = coordinateList.get(i).getLongitude();
            this.coordinates[i][1] = coordinateList.get(i).getLatitude();
        }
    }

    public String toString() {
        return "ElementLineStringGeometry{coordinates=" + Arrays.toString((Object[])this.coordinates) + "}";
    }

    public Double[][] getCoordinates() {
        return this.coordinates;
    }

    public ElementLineStringGeometry setCoordinates(Double[][] coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

