/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.flightarea.api;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.flightarea.FlightAreaMethodEnum;
import com.dji.sdk.cloudapi.flightarea.FlightAreasDroneLocation;
import com.dji.sdk.cloudapi.flightarea.FlightAreasGetRequest;
import com.dji.sdk.cloudapi.flightarea.FlightAreasGetResponse;
import com.dji.sdk.cloudapi.flightarea.FlightAreasSyncProgress;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.config.version.GatewayTypeEnum;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.events.TopicEventsRequest;
import com.dji.sdk.mqtt.events.TopicEventsResponse;
import com.dji.sdk.mqtt.requests.TopicRequestsRequest;
import com.dji.sdk.mqtt.requests.TopicRequestsResponse;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractFlightAreaService {
    @Resource
    private ServicesPublish servicesPublish;

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0, exclude={GatewayTypeEnum.RC}, include={GatewayTypeEnum.DOCK, GatewayTypeEnum.DOCK2})
    public TopicServicesResponse<ServicesReplyData> flightAreasUpdate(GatewayManager gateway) {
        return this.servicesPublish.publish(gateway.getGatewaySn(), FlightAreaMethodEnum.FLIGHT_AREAS_UPDATE.getMethod());
    }

    @ServiceActivator(inputChannel="inboundEventsFlightAreasSyncProgress", outputChannel="outboundEvents")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    public TopicEventsResponse<MqttReply> flightAreasSyncProgress(TopicEventsRequest<FlightAreasSyncProgress> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flightAreasSyncProgress not implemented");
    }

    @ServiceActivator(inputChannel="inboundEventsFlightAreasDroneLocation", outputChannel="outboundEvents")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    public TopicEventsResponse<MqttReply> flightAreasDroneLocation(TopicEventsRequest<FlightAreasDroneLocation> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flightAreasDroneLocation not implemented");
    }

    @ServiceActivator(inputChannel="inboundRequestsFlightAreasGet", outputChannel="outboundRequests")
    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_0)
    public TopicRequestsResponse<MqttReply<FlightAreasGetResponse>> flightAreasGet(TopicRequestsRequest<FlightAreasGetRequest> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("flightAreasGet not implemented");
    }
}

