/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.device;

import com.dji.sdk.cloudapi.device.PayloadIndex;
import com.dji.sdk.cloudapi.livestream.VideoTypeEnum;
import com.dji.sdk.exception.CloudSDKErrorEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class VideoId {
    @NotNull
    private String droneSn;
    @NotNull
    private PayloadIndex payloadIndex;
    @NotNull
    private VideoTypeEnum videoType = VideoTypeEnum.NORMAL;

    public VideoId() {
    }

    @JsonCreator
    public VideoId(String videoId) {
        if (!StringUtils.hasText((String)videoId)) {
            return;
        }
        String[] videoIdArr = (String[])Arrays.stream(videoId.split("/")).toArray(String[]::new);
        if (videoIdArr.length != 3) {
            throw new CloudSDKException(CloudSDKErrorEnum.INVALID_PARAMETER);
        }
        this.droneSn = videoIdArr[0];
        this.payloadIndex = new PayloadIndex(videoIdArr[1]);
        this.videoType = VideoTypeEnum.find(videoIdArr[2].split("-")[0]);
    }

    @JsonValue
    public String toString() {
        if (Objects.isNull(this.payloadIndex)) {
            return "";
        }
        return String.format("%s/%s/%s-0", this.droneSn, this.payloadIndex.toString(), this.videoType.getType());
    }

    public String getDroneSn() {
        return this.droneSn;
    }

    public VideoId setDroneSn(String droneSn) {
        this.droneSn = droneSn;
        return this;
    }

    public PayloadIndex getPayloadIndex() {
        return this.payloadIndex;
    }

    public VideoId setPayloadIndex(PayloadIndex payloadIndex) {
        this.payloadIndex = payloadIndex;
        return this;
    }

    public VideoTypeEnum getVideoType() {
        return this.videoType;
    }

    public VideoId setVideoType(VideoTypeEnum videoType) {
        this.videoType = videoType;
        return this;
    }
}

