/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.device;

import com.dji.sdk.cloudapi.livestream.LiveErrorCodeEnum;
import com.dji.sdk.common.ErrorCodeSourceEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class DockLiveErrorStatus {
    private static final int MOD = 100000;
    private ErrorCodeSourceEnum source = ErrorCodeSourceEnum.DOCK;
    private LiveErrorCodeEnum errorCode;
    private boolean success;

    public String toString() {
        return "{errorCode=" + this.getCode() + ", errorMsg=" + this.getMessage() + "}";
    }

    @JsonCreator
    public DockLiveErrorStatus(int code) {
        this.success = 0 == code;
        this.source = ErrorCodeSourceEnum.find(code / 100000);
        this.errorCode = LiveErrorCodeEnum.find(code % 100000);
    }

    public String getMessage() {
        return this.errorCode.getMessage();
    }

    @JsonValue
    public Integer getCode() {
        return this.source.getSource() * 100000 + this.errorCode.getCode();
    }

    public boolean isSuccess() {
        return this.success;
    }
}

