/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.debug.api;

import com.dji.sdk.annotations.CloudSDKVersion;
import com.dji.sdk.cloudapi.debug.AirConditionerModeSwitchRequest;
import com.dji.sdk.cloudapi.debug.AlarmStateSwitchRequest;
import com.dji.sdk.cloudapi.debug.BatteryMaintenanceSwitchRequest;
import com.dji.sdk.cloudapi.debug.BatteryStoreModeSwitchRequest;
import com.dji.sdk.cloudapi.debug.DebugMethodEnum;
import com.dji.sdk.cloudapi.debug.EsimActivateRequest;
import com.dji.sdk.cloudapi.debug.EsimOperatorSwitchRequest;
import com.dji.sdk.cloudapi.debug.RemoteDebugProgress;
import com.dji.sdk.cloudapi.debug.RemoteDebugResponse;
import com.dji.sdk.cloudapi.debug.SdrWorkmodeSwitchRequest;
import com.dji.sdk.cloudapi.debug.SimSlotSwitchRequest;
import com.dji.sdk.common.BaseModel;
import com.dji.sdk.common.Common;
import com.dji.sdk.common.SpringBeanUtils;
import com.dji.sdk.config.version.CloudSDKVersionEnum;
import com.dji.sdk.config.version.GatewayManager;
import com.dji.sdk.config.version.GatewayTypeEnum;
import com.dji.sdk.exception.CloudSDKException;
import com.dji.sdk.mqtt.MqttReply;
import com.dji.sdk.mqtt.events.EventsDataRequest;
import com.dji.sdk.mqtt.events.TopicEventsRequest;
import com.dji.sdk.mqtt.events.TopicEventsResponse;
import com.dji.sdk.mqtt.services.ServicesPublish;
import com.dji.sdk.mqtt.services.ServicesReplyData;
import com.dji.sdk.mqtt.services.TopicServicesResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHeaders;

public abstract class AbstractDebugService {
    @Resource
    private ServicesPublish servicesPublish;

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> debugModeOpen(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DEBUG_MODE_OPEN.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> debugModeClose(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DEBUG_MODE_CLOSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> supplementLightOpen(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.SUPPLEMENT_LIGHT_OPEN.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> supplementLightClose(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.SUPPLEMENT_LIGHT_CLOSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> batteryMaintenanceSwitch(GatewayManager gateway, BatteryMaintenanceSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.BATTERY_MAINTENANCE_SWITCH.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> airConditionerModeSwitch(GatewayManager gateway, AirConditionerModeSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.AIR_CONDITIONER_MODE_SWITCH.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> alarmStateSwitch(GatewayManager gateway, AlarmStateSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.ALARM_STATE_SWITCH.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> batteryStoreModeSwitch(GatewayManager gateway, BatteryStoreModeSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.BATTERY_STORE_MODE_SWITCH.getMethod(), request);
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> deviceReboot(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DEVICE_REBOOT.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> droneOpen(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DRONE_OPEN.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> droneClose(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DRONE_CLOSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> deviceFormat(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DEVICE_FORMAT.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> droneFormat(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.DRONE_FORMAT.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> coverOpen(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.COVER_OPEN.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> coverClose(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.COVER_CLOSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC, GatewayTypeEnum.DOCK2})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> putterOpen(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.PUTTER_OPEN.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC, GatewayTypeEnum.DOCK2})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> putterClose(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.PUTTER_CLOSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> chargeOpen(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.CHARGE_OPEN.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> chargeClose(GatewayManager gateway) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.CHARGE_CLOSE.getMethod());
    }

    @CloudSDKVersion(exclude={GatewayTypeEnum.RC})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> sdrWorkmodeSwitch(GatewayManager gateway, SdrWorkmodeSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.SDR_WORKMODE_SWITCH.getMethod(), request);
    }

    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> remoteDebug(GatewayManager gateway, DebugMethodEnum methodEnum, BaseModel request) {
        try {
            ArrayList clazz = new ArrayList();
            ArrayList<Object> args = new ArrayList<Object>();
            clazz.add(GatewayManager.class);
            args.add(gateway);
            if (Objects.nonNull(request)) {
                clazz.add(request.getClass());
                args.add(request);
            }
            AbstractDebugService abstractDebugService = (AbstractDebugService)SpringBeanUtils.getBean(this.getClass());
            Method method = abstractDebugService.getClass().getDeclaredMethod(Common.convertSnake(methodEnum.getMethod()), (Class[])clazz.toArray(Class[]::new));
            return (TopicServicesResponse)method.invoke((Object)abstractDebugService, args.toArray());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new CloudSDKException(e);
        }
        catch (InvocationTargetException e) {
            throw new CloudSDKException(e.getTargetException());
        }
    }

    @ServiceActivator(inputChannel="inboundEventsControlProgress", outputChannel="outboundEvents")
    public TopicEventsResponse<MqttReply> remoteDebugProgress(TopicEventsRequest<EventsDataRequest<RemoteDebugProgress>> request, MessageHeaders headers) {
        throw new UnsupportedOperationException("remoteDebugProgress not implemented");
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_1, include={GatewayTypeEnum.DOCK2})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> esimActivate(GatewayManager gateway, EsimActivateRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.ESIM_ACTIVATE.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_1, include={GatewayTypeEnum.DOCK2})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> simSlotSwitch(GatewayManager gateway, SimSlotSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.SIM_SLOT_SWITCH.getMethod(), request);
    }

    @CloudSDKVersion(since=CloudSDKVersionEnum.V1_0_1, include={GatewayTypeEnum.DOCK2})
    public TopicServicesResponse<ServicesReplyData<RemoteDebugResponse>> esimOperatorSwitch(GatewayManager gateway, EsimOperatorSwitchRequest request) {
        return this.servicesPublish.publish(new TypeReference<RemoteDebugResponse>(){}, gateway.getGatewaySn(), DebugMethodEnum.ESIM_OPERATOR_SWITCH.getMethod(), request);
    }
}

