/*
 * Decompiled with CFR 0.152.
 */
package com.dji.sdk.cloudapi.control;

import com.dji.sdk.exception.CloudSDKException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum ExposureModeEnum {
    AUTO(1),
    SHUTTER_PRIORITY(2),
    APERTURE_PRIORITY(3),
    MANUAL(4);

    private final int mode;

    private ExposureModeEnum(int mode) {
        this.mode = mode;
    }

    @JsonValue
    public int getMode() {
        return this.mode;
    }

    @JsonCreator
    public static ExposureModeEnum find(int mode) {
        return Arrays.stream(ExposureModeEnum.values()).filter(modeEnum -> modeEnum.mode == mode).findAny().orElseThrow(() -> new CloudSDKException(ExposureModeEnum.class, mode));
    }
}

