/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.utils;

public class ByteUtils {
    public static byte[] mergeBytes(byte[] bytes1, byte[] bytes2) {
        int length1 = bytes1.length;
        int length2 = bytes2.length;
        byte[] res = new byte[length1 + length2];
        System.arraycopy(bytes1, 0, res, 0, length1);
        System.arraycopy(bytes2, 0, res, length1, length2);
        return res;
    }

    public static byte[] mergeAll(byte[] ... bytes) {
        int total = bytes.length;
        int length = 0;
        for (int i = 0; i < total; ++i) {
            length += bytes[i].length;
        }
        byte[] res = new byte[length];
        int current = 0;
        for (int i = 0; i < total; ++i) {
            System.arraycopy(bytes[i], 0, res, current, bytes[i].length);
            current += bytes[i].length;
        }
        return res;
    }

    public static String byteToHexString(byte[] byteArray) {
        int length = byteArray.length;
        StringBuilder sb = new StringBuilder(length);
        for (byte b : byteArray) {
            int v = b & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] subBytes(byte[] source, int startIndex, int endIndex) {
        byte[] res = new byte[endIndex - startIndex + 1];
        System.arraycopy(source, startIndex, res, 0, res.length);
        return res;
    }

    public static byte[] subBytes(byte[] source, int startIndex) {
        byte[] res = new byte[source.length - startIndex];
        System.arraycopy(source, startIndex, res, 0, res.length);
        return res;
    }
}

