/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.sm4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.wsttech.gm.sm4.SM4Params;
import net.wsttech.gm.utils.PKCSUtils;

public class SM4Process {
    public static byte[] sm4ECBCrypt(long[] rk, byte[] input, boolean isEncrypt, String pkcs) {
        if (isEncrypt) {
            input = PKCSUtils.padding(input, pkcs);
        }
        byte[] output = new byte[]{};
        try {
            ByteArrayInputStream bins = new ByteArrayInputStream(input);
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            for (int length = input.length; length > 0; length -= 16) {
                byte[] in = new byte[16];
                byte[] out = new byte[16];
                bins.read(in);
                SM4Process.sm4OneRound(rk, in, out);
                bous.write(out);
            }
            output = bous.toByteArray();
            if (!isEncrypt) {
                output = PKCSUtils.PKCSUnPadding(output);
            }
            bins.close();
            bous.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static byte[] sm4CBCCrypt(long[] rk, byte[] iv, byte[] input, boolean isEncrypt, String pkcs) {
        if (isEncrypt) {
            input = PKCSUtils.padding(input, pkcs);
        }
        byte[] output = new byte[]{};
        try {
            int length;
            ByteArrayInputStream bins = new ByteArrayInputStream(input);
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            if (isEncrypt) {
                for (length = input.length; length > 0; length -= 16) {
                    byte[] in = new byte[16];
                    byte[] out = new byte[16];
                    byte[] out1 = new byte[16];
                    bins.read(in);
                    for (int i = 0; i < 16; ++i) {
                        out[i] = (byte)SM4Process.xor(in[i], iv[i]);
                    }
                    SM4Process.sm4OneRound(rk, out, out1);
                    System.arraycopy(out1, 0, iv, 0, 16);
                    bous.write(out1);
                }
            } else {
                byte[] temp = new byte[16];
                while (length > 0) {
                    byte[] in = new byte[16];
                    byte[] out = new byte[16];
                    byte[] out1 = new byte[16];
                    bins.read(in);
                    System.arraycopy(in, 0, temp, 0, 16);
                    SM4Process.sm4OneRound(rk, in, out);
                    for (int i = 0; i < 16; ++i) {
                        out1[i] = (byte)SM4Process.xor(out[i], iv[i]);
                    }
                    System.arraycopy(temp, 0, iv, 0, 16);
                    bous.write(out1);
                    length -= 16;
                }
            }
            output = bous.toByteArray();
            if (!isEncrypt) {
                output = PKCSUtils.PKCSUnPadding(output);
            }
            bins.close();
            bous.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    private static long byteToLong(byte[] b, int i) {
        return (long)(b[i] & 0xFF) << 24 | (long)((b[i + 1] & 0xFF) << 16) | (long)((b[i + 2] & 0xFF) << 8) | (long)(b[i + 3] & 0xFF) & 0xFFFFFFFFL;
    }

    private static void PutULongBe(long n, byte[] b, int i) {
        b[i] = (byte)(0xFFL & n >> 24);
        b[i + 1] = (byte)(0xFFL & n >> 16);
        b[i + 2] = (byte)(0xFFL & n >> 8);
        b[i + 3] = (byte)(0xFFL & n);
    }

    private static long ROTL(long x, int n) {
        return SM4Process.SHL(x, n) | x >> 32 - n;
    }

    private static long SHL(long x, int n) {
        return (x & 0xFFFFFFFFFFFFFFFFL) << n;
    }

    public static void SWAP(long[] rk, int i) {
        long t = rk[i];
        rk[i] = rk[31 - i];
        rk[31 - i] = t;
    }

    private static byte sm4Sbox(byte inch) {
        int i = inch & 0xFF;
        return SM4Params.Sbox[i];
    }

    private static long sm4F(long x0, long x1, long x2, long x3, long rk) {
        return SM4Process.xor(x0, SM4Process.sm4Lt(SM4Process.xor(x1, x2, x3, rk)));
    }

    private static long sm4Lt(long ka) {
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        SM4Process.PutULongBe(ka, a, 0);
        b[0] = SM4Process.sm4Sbox(a[0]);
        b[1] = SM4Process.sm4Sbox(a[1]);
        b[2] = SM4Process.sm4Sbox(a[2]);
        b[3] = SM4Process.sm4Sbox(a[3]);
        long bb = SM4Process.byteToLong(b, 0);
        return SM4Process.xor(bb, SM4Process.ROTL(bb, 2), SM4Process.ROTL(bb, 10), SM4Process.ROTL(bb, 18), SM4Process.ROTL(bb, 24));
    }

    private static long sm4CalciRK(long ka) {
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        SM4Process.PutULongBe(ka, a, 0);
        b[0] = SM4Process.sm4Sbox(a[0]);
        b[1] = SM4Process.sm4Sbox(a[1]);
        b[2] = SM4Process.sm4Sbox(a[2]);
        b[3] = SM4Process.sm4Sbox(a[3]);
        long bb = SM4Process.byteToLong(b, 0);
        return SM4Process.xor(bb, SM4Process.ROTL(bb, 13), SM4Process.ROTL(bb, 23));
    }

    private static void sm4OneRound(long[] rk, byte[] input, byte[] output) {
        long[] X = new long[36];
        X[0] = SM4Process.byteToLong(input, 0);
        X[1] = SM4Process.byteToLong(input, 4);
        X[2] = SM4Process.byteToLong(input, 8);
        X[3] = SM4Process.byteToLong(input, 12);
        for (int i = 0; i < 32; ++i) {
            X[i + 4] = SM4Process.sm4F(X[i], X[i + 1], X[i + 2], X[i + 3], rk[i]);
        }
        SM4Process.PutULongBe(X[35], output, 0);
        SM4Process.PutULongBe(X[34], output, 4);
        SM4Process.PutULongBe(X[33], output, 8);
        SM4Process.PutULongBe(X[32], output, 12);
    }

    public static void sm4SetKey(long[] rk, byte[] key) {
        long[] MK = new long[4];
        long[] k = new long[36];
        MK[0] = SM4Process.byteToLong(key, 0);
        MK[1] = SM4Process.byteToLong(key, 4);
        MK[2] = SM4Process.byteToLong(key, 8);
        MK[3] = SM4Process.byteToLong(key, 12);
        k[0] = SM4Process.xor(MK[0], SM4Params.FK[0]);
        k[1] = SM4Process.xor(MK[1], SM4Params.FK[1]);
        k[2] = SM4Process.xor(MK[2], SM4Params.FK[2]);
        k[3] = SM4Process.xor(MK[3], SM4Params.FK[3]);
        for (int i = 0; i < 32; ++i) {
            k[i + 4] = SM4Process.xor(k[i], SM4Process.sm4CalciRK(SM4Process.xor(k[i + 1], k[i + 2], k[i + 3], SM4Params.CK[i])));
            rk[i] = k[i + 4];
        }
    }

    private static long xor(long ... params) {
        long res = 0L;
        for (int i = 0; i < params.length; ++i) {
            res ^= params[i];
        }
        return res & 0xFFFFFFFFL;
    }
}

