/*
 * Decompiled with CFR 0.152.
 */
package net.wsttech.gm.sm3;

import java.util.Arrays;
import net.wsttech.gm.sm3.HMASM3CProcess;
import net.wsttech.gm.sm3.SM3Params;
import net.wsttech.gm.sm3.SM3Process;

public class SM3 {
    public static byte[] hash(byte[] m) {
        byte[] m1 = SM3Process.padding(m);
        int n = m1.length / 64;
        byte[] vi0 = SM3Params.IV.toByteArray();
        byte[] vi1 = null;
        for (int i = 0; i < n; ++i) {
            byte[] b = Arrays.copyOfRange(m1, i * 64, (i + 1) * 64);
            vi1 = SM3Process.CF(vi0, b);
            vi0 = vi1;
        }
        return vi1;
    }

    public static byte[] hmac(byte[] key, byte[] m) {
        byte[] init = HMASM3CProcess.hmacInit(key);
        byte[] update = HMASM3CProcess.hmacUpdate(init, m);
        return HMASM3CProcess.hmacFinal(init, update);
    }
}

