/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Iterator;
import org.september.core.exception.BusinessException;
import org.september.pisces.user.permission.entity.SystemUser;
import org.september.simpleweb.utils.SessionHelper;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class UserSessionHelper {
    private static String WebTreeKeyPrefix = "_menuTree_";

    public static Long getUserId() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (sra != null);
        HttpServletRequest req = sra.getRequest();
        String userIdString = req.getHeader("userId");
        if (!StringUtils.hasLength((String)userIdString)) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55");
        }
        return Long.parseLong(userIdString);
    }

    public static SystemUser getLoginUser() {
        return (SystemUser)SessionHelper.getSessionUser(SystemUser.class);
    }

    public static void setLoginUser(SystemUser user) {
        SessionHelper.setSessionUser((Object)user);
    }

    public static Long getLoginUid() {
        return UserSessionHelper.getLoginUser().getId();
    }

    public static String getLoginAccount() {
        return UserSessionHelper.getLoginUser().getUsername();
    }

    public static void remove() {
        SessionHelper.getSession().removeAttribute("sessionUser");
        Iterator it = SessionHelper.getSession().getAttributeNames().asIterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(WebTreeKeyPrefix)) continue;
            SessionHelper.getSession().removeAttribute(key);
        }
    }

    public static void setMenuTree(String groupName, Object modules) {
        SessionHelper.getSession().setAttribute(WebTreeKeyPrefix + groupName, modules);
    }

    public static Object getMenuTree(String groupName) {
        return SessionHelper.getSession().getAttribute(WebTreeKeyPrefix + groupName);
    }
}

