/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.service;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.september.core.component.ApplicationContextHolder;
import org.september.core.exception.BusinessException;
import org.september.core.util.MD5;
import org.september.core.util.PasswordUtil;
import org.september.pisces.cache.aop.SimpleCache;
import org.september.pisces.user.permission.entity.RolePermission;
import org.september.pisces.user.permission.entity.SystemRole;
import org.september.pisces.user.permission.entity.SystemUser;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.pisces.user.permission.service.PiscesPermissionService;
import org.september.pisces.user.permission.service.TokenSessionManager;
import org.september.pisces.user.permission.service.UserOnlineStatusService;
import org.september.pisces.user.permission.service.UserPwdErrorCheckService;
import org.september.pisces.user.permission.utils.EncryptUtil;
import org.september.pisces.user.permission.utils.UserSessionHelper;
import org.september.pisces.user.permission.vo.PermissionTreeNode;
import org.september.simpleweb.utils.IpUtils;
import org.september.simpleweb.utils.SessionHelper;
import org.september.smartdao.CommonDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SystemUserService {
    @Autowired
    private CommonDao dao;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private UserPwdErrorCheckService userPwdErrorCheckService;

    public SystemUser login(String username, String password, boolean byToken) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = IpUtils.getIpAddr((HttpServletRequest)request);
        SystemUser user = this.getUserByUserName(username);
        if (user == null) {
            this.userPwdErrorCheckService.checkPwdErrorLimits(ip);
            throw new BusinessException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        try {
            password = EncryptUtil.decrypt(password);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bc6\u7801\u9a8c\u8bc1\u9519\u8bef", (Throwable)e);
        }
        password = MD5.md5WithDefaultSalt((String)password);
        if (!password.equals(user.getPassword())) {
            this.userPwdErrorCheckService.checkPwdErrorLimits(ip);
        }
        if (byToken) {
            String token = TokenSessionManager.addSessionUser(user);
            user.setToken(token);
        } else {
            UserSessionHelper.setLoginUser(user);
        }
        this.userPwdErrorCheckService.pass(ip);
        if ("superadmin".equals(user.getUsername())) {
            PiscesPermissionService piscesPermissionService = (PiscesPermissionService)ApplicationContextHolder.getContext().getBean(PiscesPermissionService.class);
            for (PermissionTreeNode node : piscesPermissionService.getAllPermissions()) {
                user.getPermitUrlList().addAll(node.getResource());
            }
        } else {
            List<RolePermission> perms = this.getPermissionOfUser(user.getId());
            for (RolePermission rp : perms) {
                user.getPermitUrlList().add(rp.getResource());
            }
        }
        UserOnlineStatusService.setCurrentUserSid(user.getId(), SessionHelper.getSession().getId());
        return user;
    }

    public void doResetMyPwd(Long id, String oldPwd, String newPwd, String newPwdRepeat) throws Exception {
        if (StringUtils.isEmpty((Object)oldPwd)) {
            throw new BusinessException("\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)newPwd)) {
            throw new BusinessException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)newPwdRepeat)) {
            throw new BusinessException("\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        oldPwd = EncryptUtil.decrypt(oldPwd);
        newPwd = EncryptUtil.decrypt(newPwd);
        newPwdRepeat = EncryptUtil.decrypt(newPwdRepeat);
        if (!PasswordUtil.isComplexPwd((String)newPwd)) {
            throw new BusinessException("\u5bc6\u7801\u4e0d\u80fd\u5c11\u4e8e8\u4f4d\uff0c\u4e14\u5305\u542b\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u7279\u6b8a\u5b57\u7b26\u4e2d\u4efb\u610f\u4e24\u79cd\u7ec4\u5408");
        }
        if (!StringUtils.pathEquals((String)newPwd, (String)newPwdRepeat)) {
            throw new BusinessException("\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u6837");
        }
        if (StringUtils.pathEquals((String)oldPwd, (String)newPwd)) {
            throw new BusinessException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u4e00\u81f4");
        }
        SystemUser po = (SystemUser)this.dao.get(SystemUser.class, (Object)id);
        if (!StringUtils.pathEquals((String)MD5.md5WithDefaultSalt((String)oldPwd), (String)po.getPassword())) {
            throw new BusinessException("\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        po.setPassword(MD5.md5WithDefaultSalt((String)newPwd));
        this.dao.update((Object)po);
        this.operationLogService.addLog("\u4fee\u6539\u4e86\u7528\u6237\u3010" + po.getUsername() + "\u3011\u7684\u5bc6\u7801");
    }

    public List<SystemRole> getRolesOfUser(long userId) {
        SystemUser su = (SystemUser)this.dao.get(SystemUser.class, (Object)userId);
        ArrayList<Long> idList = new ArrayList<Long>();
        if (StringUtils.hasText((String)su.getRoleIds())) {
            for (String idStr : su.getRoleIds().split(";")) {
                if (!StringUtils.hasText((String)idStr)) continue;
                idList.add(Long.valueOf(idStr));
            }
        }
        if (idList.isEmpty()) {
            return null;
        }
        return this.dao.listByIds(SystemRole.class, idList);
    }

    public List<RolePermission> getPermissionOfUser(long userId) {
        ArrayList<RolePermission> perms = new ArrayList<RolePermission>();
        List<SystemRole> roles = this.getRolesOfUser(userId);
        if (roles == null || roles.isEmpty()) {
            return perms;
        }
        for (SystemRole role : roles) {
            RolePermission rpVo = new RolePermission();
            rpVo.setRoleId(role.getId());
            perms.addAll(this.dao.listByExample((Object)rpVo));
        }
        return perms;
    }

    public List<RolePermission> getPermissionOfRole(long roleId) {
        RolePermission vo = new RolePermission();
        vo.setRoleId(roleId);
        return this.dao.listByExample((Object)vo);
    }

    public SystemUser getUserByUserName(String username) {
        SystemUser vo = new SystemUser();
        vo.setUsername(username);
        vo.setDeleteFlag(0);
        SystemUser po = (SystemUser)this.dao.getByExample((Object)vo);
        return po;
    }

    @SimpleCache
    public SystemUser getUserById(Long id) {
        SystemUser po = (SystemUser)this.dao.get(SystemUser.class, (Object)id);
        return po;
    }

    public void addUser(SystemUser su) {
        SystemUser po = this.getUserByUserName(su.getUsername());
        if (po != null) {
            throw new BusinessException("\u7528\u6237\u540d " + su.getUsername() + " \u5df2\u5b58\u5728!");
        }
        if (!PasswordUtil.isComplexPwd((String)su.getPassword())) {
            throw new BusinessException("\u5bc6\u7801\u957f\u5ea6\u81f3\u5c118\u4f4d\uff0c\u4e14\u5305\u542b\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u7279\u6b8a\u5b57\u7b26\u4e2d\u4efb\u610f\u4e24\u79cd\u7ec4\u5408!");
        }
        String md5Password = MD5.md5WithDefaultSalt((String)su.getPassword());
        su.setPassword(md5Password);
        if (!su.getRoleIds().endsWith(";")) {
            su.setRoleIds(su.getRoleIds() + ";");
        }
        this.dao.save((Object)su);
    }
}

