/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.controller;

import jakarta.validation.Valid;
import java.util.List;
import org.september.core.constant.enums.DeleteFlag;
import org.september.core.exception.BusinessException;
import org.september.pisces.user.permission.entity.Department;
import org.september.pisces.user.permission.service.DeptService;
import org.september.pisces.user.permission.service.OperationLogService;
import org.september.simpleweb.controller.BaseController;
import org.september.simpleweb.model.ResponseVo;
import org.september.smartdao.CommonValidator;
import org.september.smartdao.common.BaseEntity;
import org.september.smartdao.common.BaseService;
import org.september.smartdao.model.Page;
import org.september.smartdao.model.ParamMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DepartmentController
extends BaseController {
    @Autowired
    private BaseService baseService;
    @Autowired
    private CommonValidator commonValidator;
    @Autowired
    private DeptService deptService;
    @Autowired
    private OperationLogService operationLogService;
    private static final String Mapping_Prefix = "/department";
    public static final String List_Page = "/department/departmentList";
    public static final String List_Data = "/department/listDepartmentData";
    public static final String Get_Data = "/department/getData";
    public static final String Add_Page = "/department/addDepartment";
    public static final String Add_Action = "/department/doAddDepartment";
    public static final String Edit_Page = "/department/editDepartment";
    public static final String Edit_Action = "/department/doUpdateDepartment";
    public static final String Delete_Action = "/department/delete";

    @RequestMapping(value={"/department/departmentList"})
    public ModelAndView DepartmentList() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/department/listDepartmentData"})
    public ResponseVo<Page<Department>> listDepartmentData(Page<Department> page, Department vo, String sortField, String sortOrder) throws Exception {
        ParamMap pm = new ParamMap((Object)vo);
        page = this.baseService.getCommonDao().findPageByParams(Department.class, page, "Department.listDepartment", pm);
        return ResponseVo.BUILDER().setData((Object)page).setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/select"})
    public ModelAndView select() throws Exception {
        ModelAndView mv = new ModelAndView();
        return mv;
    }

    @ResponseBody
    @PostMapping(value={"/department/getData"})
    public ResponseVo<List<Department>> getData() {
        Department vo = new Department();
        vo.setDeleteFlag(DeleteFlag.NotDelete.ordinal());
        List list = this.baseService.getCommonDao().listByExample((Object)vo);
        return ResponseVo.BUILDER().setData((Object)list).setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/department/addDepartment"})
    public ModelAndView addDepartment(Long parentId) throws Exception {
        ModelAndView mv = new ModelAndView();
        Department parent = (Department)((Object)this.baseService.getCommonDao().get(Department.class, (Object)parentId));
        mv.addObject("parent", (Object)parent.getName());
        mv.addObject("parentId", (Object)parentId);
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/department/doAddDepartment"})
    public ResponseVo<String> doAddDepartment(@Valid Department department) throws Exception {
        Department parent = (Department)((Object)this.baseService.getCommonDao().get(Department.class, (Object)department.getParentId()));
        if (parent == null) {
            throw new BusinessException("\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u5b58\u5728\uff01");
        }
        department.setParentId(parent.getId());
        if (this.commonValidator.exsits(Department.class, new String[]{"name", "deleteFlag"}, new Object[]{department.getName(), DeleteFlag.NotDelete.ordinal()})) {
            throw new BusinessException("\u8be5\u90e8\u95e8\u5df2\u5b58\u5728\uff0c\u521b\u5efa\u5931\u8d25\uff01");
        }
        if (this.commonValidator.exsits(Department.class, new String[]{"code", "deleteFlag"}, new Object[]{department.getCode(), DeleteFlag.NotDelete.ordinal()})) {
            throw new BusinessException("\u90e8\u95e8\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u521b\u5efa\u5931\u8d25\uff01");
        }
        department.setFullParentId(parent.getFullId());
        this.baseService.save((BaseEntity)department);
        this.operationLogService.addLog("\u6dfb\u52a0\u4e86\u90e8\u95e8\u3010" + department.getName() + "\u3011");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @RequestMapping(value={"/department/editDepartment"})
    public ModelAndView editDepartment(Long id) throws Exception {
        ModelAndView mv = new ModelAndView();
        Department po = (Department)((Object)this.baseService.getCommonDao().get(Department.class, (Object)id));
        Department parent = (Department)((Object)this.baseService.getCommonDao().get(Department.class, (Object)po.getParentId()));
        if (parent != null) {
            po.setParent(parent.getName());
        }
        mv.addObject("department", (Object)po);
        return mv;
    }

    @ResponseBody
    @RequestMapping(value={"/department/doUpdateDepartment"})
    public ResponseVo<String> doUpdateDepartment(@Valid Department vo) throws Exception {
        Department po = (Department)((Object)this.baseService.getCommonDao().get(Department.class, (Object)vo.getId()));
        if (this.commonValidator.exsitsNotMe(Department.class, new String[]{"name", "deleteFlag"}, new Object[]{vo.getName(), DeleteFlag.NotDelete.ordinal()}, (Object)vo.getId())) {
            throw new BusinessException("\u8be5\u90e8\u95e8\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u91cd\u8bd5\uff01");
        }
        po.setName(vo.getName());
        po.setDescb(vo.getDescb());
        po.setCode(vo.getCode());
        this.baseService.updateWithNullFields((BaseEntity)po);
        this.operationLogService.addLog("\u4fee\u6539\u4e86\u90e8\u95e8\u3010" + po.getName() + "\u3011");
        return ResponseVo.BUILDER().setData((Object)"").setCode(Integer.valueOf(0));
    }

    @ResponseBody
    @RequestMapping(value={"/department/delete"})
    public ResponseVo<String> delete(Long id) throws Exception {
        Department po = (Department)((Object)this.baseService.getCommonDao().get(Department.class, (Object)id));
        if (po == null) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (this.deptService.countAllUser(po.getFullId()) > 0) {
            throw new BusinessException("\u90e8\u95e8\u4e0b\u7528\u6237\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.baseService.delete((BaseEntity)po);
        this.operationLogService.addLog("\u5220\u9664\u4e86\u90e8\u95e8\u3010" + po.getName() + "\u3011");
        return ResponseVo.BUILDER().setCode(Integer.valueOf(0));
    }
}

