/*
 * Decompiled with CFR 0.152.
 */
package org.september.pisces.user.permission.service;

import java.util.HashMap;
import java.util.Map;
import org.september.core.exception.BusinessException;
import org.springframework.stereotype.Service;

@Service
public class UserPwdErrorCheckService {
    private long discardTime = 1800000L;
    private static int MaxRetryTimes = 6;
    private Map<String, ErrorInfo> errMap = new HashMap<String, ErrorInfo>();

    public boolean isOverLimits(String ip) {
        if (this.errMap.containsKey(ip)) {
            ErrorInfo err = this.errMap.get(ip);
            return err.errorTimes >= MaxRetryTimes;
        }
        return false;
    }

    public void addErrorTime(String ip) {
        if (this.errMap.containsKey(ip)) {
            ErrorInfo err = this.errMap.get(ip);
            ++err.errorTimes;
        } else {
            ErrorInfo err = new ErrorInfo();
            err.lastestLoginTime = System.currentTimeMillis();
            err.errorTimes = 1;
            this.errMap.put(ip, err);
        }
    }

    public void pass(String ip) {
        this.errMap.remove(ip);
    }

    public void removeOverTimeErrorInfo(String ip) {
        if (this.errMap.containsKey(ip)) {
            ErrorInfo err = this.errMap.get(ip);
            if (System.currentTimeMillis() - err.lastestLoginTime > this.discardTime) {
                this.errMap.remove(ip);
            }
        }
    }

    public int getErrorTimes(String ip) {
        if (this.errMap.containsKey(ip)) {
            return this.errMap.get((Object)ip).errorTimes;
        }
        return 0;
    }

    public int getLeftRetryTimes(String ip) {
        return MaxRetryTimes - this.getErrorTimes(ip);
    }

    public void checkPwdErrorLimits(String ip) {
        this.removeOverTimeErrorInfo(ip);
        if (this.isOverLimits(ip)) {
            throw new BusinessException("\u91cd\u8bd5\u6b21\u6570\u8d85\u8fc76\u6b21\uff0c\u8bf7\u534a\u5c0f\u65f6\u540e\u91cd\u8bd5\u767b\u5f55");
        }
        this.addErrorTime(ip);
        int left = this.getLeftRetryTimes(ip);
        throw new BusinessException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef,\u8fd8\u53ef\u4ee5\u5c1d\u8bd5" + left + "\u6b21");
    }

    private class ErrorInfo {
        private Long lastestLoginTime;
        private int errorTimes;

        private ErrorInfo() {
        }
    }
}

