<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>定时任务管理</title>
<script src="/assets/jquery/jquery-3.1.1.min.js"></script>
<script src="/assets/layui-2.9.18/layui.js"></script>
<link rel="stylesheet" href="/assets/layui-2.9.18/css/layui.css">
<link rel="stylesheet" href="/assets/layui-2.9.18/css/admin.css">
<script src="/assets/september/common.js"></script>
<script src="/assets/september/htmlBuilder.js"></script>
<script src="/assets/september/search.js"></script>
<link rel="stylesheet" href="/assets/pages/list.css">
</head>
<body class="layui-layout-body">
	<div id="LAY_app">
		<div class="layui-layout layui-layout-admin">
			<!-- 主体内容 -->
			<div class="layui-fluid">
					<div class="layui-card">
						<div class="layui-form layui-card-header layuiadmin-card-header-auto">
							<div class="layui-form-item">
								<div class="layui-inline">
									<label class="layui-search-form-label">名称</label>
									<div class="layui-search-input-inline">
										<input type="text" name="taskName" autocomplete="off" class="layui-input">
									</div>
								</div>
			
								<div class="layui-inline">
									<button class="layui-btn layuiadmin-btn-list" lay-submit lay-filter="LAY-app-contlist-search" onclick="doSearch(1);">
										<i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
									</button>
								</div>
			
							</div>
						</div>
			
						<div class="layui-card-body">
							<div id="form" class="layui-table-box layui-form">
								<table id="LAY-app-content-list" class="layui-table">
									<thead>
										<tr>
											<td align="center"><span>任务名称</span></td>
											<td align="center"><span>方法</span></td>
											<td align="center"><span>cron</span></td>
											<td align="center"><span>备注</span></td>
											<td align="center"><span>上次运行时间</span></td>
											<td align="center"><span>状态</span></td>
											<th data-minwidth="150" class=" layui-table-col-special">
												<div class="layui-table-cell" align="center">
													<span>操作</span>
												</div>
											</th>
										</tr>
									</thead>
									<tbody class="layui-table-body layui-table-main">
										<tr class="data_row" style="display: none">
											<td align="center"><span>$[taskName]-$[id]</span></td>
											<td align="center"><span>$[api]</span></td>
											<td align="center"><span>$[cron]</span></td>
											<td align="center"><span>$[remark]</span></td>
											<td align="center"><span>$[lastExecuteTime]</span></td>
											<td align="center"><span script="true">getTaskStatus('$[runStatus]')</span></td>
											<td align="center" data-minwidth="150" class="layui-table-col-special">
												<div class="layui-table-cell">
													<a class="layui-btn layui-btn-danger layui-btn-xs" onclick="pause($[id])">暂停</a>
													<a class="layui-btn layui-btn-normal layui-btn-xs" onclick="resume($[id])">恢复</a>
													<a class="layui-btn layui-btn-info layui-btn-xs" onclick="openLog($[id])">记录</a>
												</div>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
			
							<div class="layui-card-body">
								<div id="page"></div>
							</div>
						</div>
					</div>
				</div>
			<!-- 主体内容结束-->
		</div>
	</div>

<script type="text/javascript">
	searchUrl = '/pisces/task/listTaskData';
	layui.use(function(){
    	var layer = layui.layer;
    	doSearch(1);
  	});
	
	function pause(id) {
		sajax({
            type: "POST",
            url: "/pisces/task/pause?id=" + id,
            success: function (data) {
                doPage(currentPage);
            }
        });
    }
    
    function resume(id) {
		sajax({
            type: "POST",
            url: "/pisces/task/resume?id=" + id,
            success: function (data) {
                doPage(currentPage);
            }
        });
    }
    
    function openLog(id) {
    	layer.open({maxmin : true,
			type : 2,
			title : '执行记录',
			area : [ '60%', '500px' ],
			content : '/pisces/taskLog/logList?taskId='+id
		});
    }
	
	function getTaskStatus(status){
		if(status==0){
			return '待运行';
		}else if(status==1){
			return '运行中';
		}else if(status==-1){
			return '已暂停';
		}else{
			return '未知';
		}
		
	}
</script>
	
	
</body>
</html>
